/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.command.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CommandResultImpl;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.command.AbstractGraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.context.GraphEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleEvaluationContextBuilder;

public abstract class AbstractCompositeCommand<T, V>
implements Command<T, V> {
    protected final List<Command<T, V>> commands = new LinkedList<Command<T, V>>();
    private boolean initialized = false;

    public AbstractCompositeCommand<T, V> addCommand(Command<T, V> command) {
        this.commands.add(command);
        return this;
    }

    protected CommandResult<V> doAllow(T context, Command<T, V> command) {
        return command.allow(context);
    }

    protected abstract CommandResult<V> doExecute(T var1, Command<T, V> var2);

    protected abstract CommandResult<V> doUndo(T var1, Command<T, V> var2);

    public CommandResult<V> allow(T context) {
        this.ensureInitialized(context);
        LinkedList<CommandResult<V>> results = new LinkedList<CommandResult<V>>();
        for (Command<T, V> command : this.commands) {
            CommandResult<V> result = this.doAllow(context, command);
            results.add(result);
            if (!CommandUtils.isError(result)) continue;
            break;
        }
        return this.buildResult(results);
    }

    public CommandResult<V> execute(T context) {
        this.ensureInitialized(context);
        return this.executeCommands(context);
    }

    protected CommandResult<V> executeCommands(T context) {
        return this.processMultipleCommands(this.commands, command -> this.doExecute(context, (Command<T, V>)command), command -> this.doUndo(context, (Command<T, V>)command));
    }

    public CommandResult<V> undo(T context) {
        return this.undo(context, this.isUndoReverse());
    }

    public int size() {
        return this.commands.size();
    }

    public boolean isEmpty() {
        return this.commands.isEmpty();
    }

    public List<Command<T, V>> getCommands() {
        return this.commands;
    }

    protected AbstractCompositeCommand<T, V> initialize(T context) {
        return this;
    }

    public boolean isUndoReverse() {
        return true;
    }

    protected CommandResult<V> undo(T context, boolean reverse) {
        List<Command<T, V>> collected = reverse ? this.commands.stream().collect(AbstractCompositeCommand.reverse()) : this.commands.stream().collect(AbstractCompositeCommand.forward());
        return this.processMultipleCommands(collected, command -> this.doUndo(context, (Command<T, V>)command), command -> this.doExecute(context, (Command<T, V>)command));
    }

    protected Collection<RuleViolation> evaluate(GraphCommandExecutionContext context, Function<RuleEvaluationContextBuilder.GraphContextBuilder, GraphEvaluationContext> contextBuilder) {
        return (Collection)((AbstractGraphCommandExecutionContext)context).evaluate(contextBuilder).violations();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void ensureInitialized(T context) {
        if (!this.isInitialized()) {
            this.initialize(context);
            this.initialized = true;
        }
    }

    protected CommandResult<V> processMultipleFunctions(Iterable<Command<T, V>> commands, Function<Command<T, V>, CommandResult<V>> function, Consumer<Iterable<Command<T, V>>> revertCandidates) {
        Stack<Command<T, V>> executedCommands = new Stack<Command<T, V>>();
        LinkedList<CommandResult<V>> results = new LinkedList<CommandResult<V>>();
        for (Command<T, V> command : commands) {
            CommandResult<V> violations = function.apply(command);
            results.add(violations);
            if (CommandResult.Type.ERROR.equals((Object)violations.getType())) {
                revertCandidates.accept(executedCommands);
                break;
            }
            executedCommands.push(command);
        }
        return this.buildResult(results);
    }

    protected CommandResult<V> processMultipleCommands(Iterable<Command<T, V>> commands, Function<Command<T, V>, CommandResult<V>> executorFunction, Function<Command<T, V>, CommandResult<V>> revertFunction) {
        return this.processMultipleFunctions(commands, executorFunction, revertCandidates -> this.processMultipleFunctions((Iterable<Command<T, V>>)revertCandidates, revertFunction, c -> {}));
    }

    protected CommandResult<V> buildResult(List<CommandResult<V>> results) {
        CommandResult.Type[] type = new CommandResult.Type[]{CommandResult.Type.INFO};
        LinkedList violations = new LinkedList();
        results.stream().filter(Objects::nonNull).forEach(rr -> {
            Iterable rrIter;
            if (this.hasMoreSeverity(rr.getType(), type[0])) {
                type[0] = rr.getType();
            }
            if (null != (rrIter = rr.getViolations())) {
                rrIter.forEach(violations::add);
            }
        });
        return new CommandResultImpl(type[0], violations);
    }

    private boolean hasMoreSeverity(CommandResult.Type type, CommandResult.Type reference) {
        return type.getSeverity() > reference.getSeverity();
    }

    private static <T> Collector<T, ?, List<T>> forward() {
        return Collectors.toList();
    }

    private static <T> Collector<T, ?, List<T>> reverse() {
        return Collectors.collectingAndThen(Collectors.toList(), l -> {
            Collections.reverse(l);
            return l;
        });
    }

    public String toString() {
        String s = "[" + this.getClass().getSimpleName() + "]";
        for (int x = 0; x < this.commands.size(); ++x) {
            s = s + " {(" + x + ")[" + this.commands.get(x) + "]}\n";
        }
        return s;
    }
}

