/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.OrientedEdge;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03.LayerCrossingCount;

public class VerticesTransposer {
    private final LayerCrossingCount crossingCount;

    @Inject
    public VerticesTransposer(LayerCrossingCount crossingCount) {
        this.crossingCount = crossingCount;
    }

    void transpose(List<GraphLayer> layers, List<OrientedEdge> edges, int currentIteration) {
        boolean bottomUp;
        boolean improved = true;
        boolean bl = bottomUp = currentIteration % 2 == 0;
        while (improved) {
            GraphLayer previous;
            GraphLayer current;
            int index;
            improved = false;
            if (bottomUp) {
                for (index = layers.size() - 1; index > 0; --index) {
                    current = layers.get(index - 1);
                    previous = layers.get(index);
                    improved = this.doTranspose(current, previous, edges);
                }
                continue;
            }
            for (index = 1; index < layers.size(); ++index) {
                current = layers.get(index);
                previous = layers.get(index - 1);
                improved = this.doTranspose(current, previous, edges);
            }
        }
    }

    private boolean doTranspose(GraphLayer current, GraphLayer previous, List<OrientedEdge> edges) {
        List vertices = current.getVertices();
        boolean improved = false;
        for (int i = 1; i < vertices.size(); ++i) {
            int currentCrossing = this.crossingCount.crossing(edges, previous, current);
            Collections.swap(vertices, i, i - 1);
            int newCrossing = this.crossingCount.crossing(edges, previous, current);
            if (newCrossing >= currentCrossing) {
                Collections.swap(vertices, i - 1, i);
                continue;
            }
            improved = true;
        }
        return improved;
    }
}

