/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.profile;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.ProfileManager;
import org.kie.workbench.common.stunner.core.profile.Profile;

public abstract class AbstractProfileManager
implements ProfileManager {
    protected abstract Function<String, Annotation> getQualifier();

    protected abstract Iterable<Profile> getAllProfileInstances();

    protected abstract Iterable<Profile> selectProfileInstances(Annotation ... var1);

    public Collection<Profile> getAllProfiles() {
        ArrayList<Profile> result = new ArrayList<Profile>();
        this.getAllProfileInstances().forEach(result::add);
        return result;
    }

    public Profile getProfile(String id) {
        return null != id ? (Profile)this.getAllProfiles().stream().filter(profile -> profile.getProfileId().equals(id)).findFirst().orElse(null) : null;
    }

    public Collection<Profile> getProfiles(String definitionSetId) {
        Annotation qualifier = this.getQualifier().apply(definitionSetId);
        ArrayList<Profile> result = new ArrayList<Profile>();
        this.selectProfileInstances(qualifier).forEach(result::add);
        result.add(this.getDefaultProfileInstance());
        return result;
    }

    public Profile getProfile(String definitionSetId, String id) {
        Annotation qualifier = this.getQualifier().apply(definitionSetId);
        Profile profile = this.getProfile(id);
        if (null == profile) {
            profile = this.getDefaultDomainProfile(qualifier);
        }
        return profile;
    }

    private Profile getDefaultDomainProfile(Annotation qualifier) {
        Iterator<Profile> domainDefaultProfile = this.selectProfileInstances(qualifier, DefinitionManager.DEFAULT_QUALIFIER).iterator();
        if (domainDefaultProfile.hasNext()) {
            return domainDefaultProfile.next();
        }
        return this.getDefaultProfileInstance();
    }

    private Profile getDefaultProfileInstance() {
        return this.selectProfileInstances(DefinitionManager.DEFAULT_QUALIFIER).iterator().next();
    }
}

