/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;

public class DefinitionIdMap<V> {
    private final Map<String, V> entries;

    public DefinitionIdMap() {
        this.entries = new LinkedHashMap<String, V>();
    }

    public DefinitionIdMap(int size) {
        this.entries = new HashMap<String, V>(size);
    }

    public DefinitionIdMap<V> put(Class<?> definitionType, V value) {
        this.entries.put(DefinitionIdMap.getDefinitionId(definitionType), value);
        return this;
    }

    public DefinitionIdMap<V> put(String key, V value) {
        this.entries.put(key, value);
        return this;
    }

    public V get(Class<?> definitionType) {
        return this.entries.get(DefinitionIdMap.getDefinitionId(definitionType));
    }

    public V get(String key) {
        V value = this.entries.get(key);
        if (null == value) {
            return this.entries.entrySet().stream().filter(entry -> key.startsWith((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
        }
        return value;
    }

    public void clear() {
        this.entries.clear();
    }

    private static String getDefinitionId(Class<?> type) {
        return BindableAdapterUtils.getDefinitionId(type);
    }
}

