/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.bpmn2;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class TypeTransformer {
    private ObjectMapper mapper = new ObjectMapper();
    private ClassLoader classLoader;

    public TypeTransformer() {
        this(TypeTransformer.class.getClassLoader());
    }

    public TypeTransformer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object transform(Object toMarshal, String className) throws ClassNotFoundException, IOException {
        JavaParser parser = new JavaParser();
        ParseResult unit = parser.parseType(className);
        if (!unit.isSuccessful()) {
            return toMarshal;
        }
        ClassOrInterfaceType type = (ClassOrInterfaceType)unit.getResult().get();
        Class<?> targetClazz = this.classLoader.loadClass(this.toString(type));
        if (Collection.class.isAssignableFrom(targetClazz) && type.getTypeArguments().isPresent()) {
            ClassOrInterfaceType argument = (ClassOrInterfaceType)((NodeList)type.getTypeArguments().get()).get(0);
            Class<?> genericType = this.classLoader.loadClass(this.toString(argument));
            CollectionType targetGenericType = this.mapper.getTypeFactory().constructCollectionType(List.class, genericType);
            return this.mapper.convertValue(toMarshal, (JavaType)targetGenericType);
        }
        return this.mapper.convertValue(toMarshal, targetClazz);
    }

    private String toString(ClassOrInterfaceType type) {
        StringBuilder str = new StringBuilder();
        type.getScope().ifPresent(s -> str.append(s.asString()).append("."));
        str.append(type.getNameAsString());
        return str.toString();
    }
}

