/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;

public class EncodingUtil {
    public static final BitSet allowed_abs_path;
    protected static final BitSet percent;
    protected static final BitSet digit;
    protected static final BitSet alpha;
    protected static final BitSet alphanum;
    protected static final BitSet hex;
    protected static final BitSet escaped;
    protected static final BitSet mark;
    protected static final BitSet unreserved;
    protected static final BitSet pchar;
    protected static final BitSet param;
    protected static final BitSet segment;
    protected static final BitSet path_segments;
    protected static final BitSet abs_path;

    private EncodingUtil() {
    }

    public static String encodePath(String unescaped) {
        byte[] rawdata = URLCodec.encodeUrl((BitSet)allowed_abs_path, (byte[])EncodingUtil.getBytes(unescaped, "UTF-8"));
        return EncodingUtil.getAsciiString(rawdata);
    }

    public static byte[] getBytes(String data, String charset) {
        if (data == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            return data.getBytes();
        }
    }

    public static String getAsciiString(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(data, 0, data.length, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(EncodingUtil.class.getSimpleName() + " requires ASCII support");
        }
    }

    public static byte[] getAsciiBytes(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return data.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(EncodingUtil.class.getSimpleName() + " requires ASCII support");
        }
    }

    public static String getString(byte[] data, String charset) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return new String(data, 0, data.length, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(data, 0, data.length);
        }
    }

    public static String decode(String escaped) {
        byte[] rawdata;
        byte[] asciiData = EncodingUtil.getAsciiBytes(escaped);
        try {
            rawdata = URLCodec.decodeUrl((byte[])asciiData);
        }
        catch (DecoderException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return EncodingUtil.getString(rawdata, "UTF-8");
    }

    static {
        int i;
        allowed_abs_path = new BitSet(256);
        percent = new BitSet(256);
        digit = new BitSet(256);
        alpha = new BitSet(256);
        alphanum = new BitSet(256);
        hex = new BitSet(256);
        escaped = new BitSet(256);
        mark = new BitSet(256);
        unreserved = new BitSet(256);
        param = pchar = new BitSet(256);
        segment = new BitSet(256);
        path_segments = new BitSet(256);
        abs_path = new BitSet(256);
        percent.set(37);
        for (i = 48; i <= 57; ++i) {
            digit.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            alpha.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            alpha.set(i);
        }
        alphanum.or(alpha);
        alphanum.or(digit);
        hex.or(digit);
        for (i = 97; i <= 102; ++i) {
            hex.set(i);
        }
        for (i = 65; i <= 70; ++i) {
            hex.set(i);
        }
        escaped.or(percent);
        escaped.or(hex);
        mark.set(45);
        mark.set(95);
        mark.set(46);
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        unreserved.or(alphanum);
        unreserved.or(mark);
        pchar.or(unreserved);
        pchar.or(escaped);
        pchar.set(58);
        pchar.set(64);
        pchar.set(38);
        pchar.set(61);
        pchar.set(43);
        pchar.set(36);
        pchar.set(44);
        segment.or(pchar);
        segment.set(59);
        segment.or(param);
        path_segments.set(47);
        path_segments.or(segment);
        abs_path.set(47);
        abs_path.or(path_segments);
        allowed_abs_path.or(abs_path);
        allowed_abs_path.andNot(percent);
        allowed_abs_path.clear(43);
    }
}

