/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.screens.explorer.backend.server.ExplorerServiceHelper;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.Option;
import org.kie.workbench.common.services.shared.project.KieModuleService;

public class FolderListingResolver {
    private FolderItem selectedItem;
    private Module selectedModule;
    private Package selectedPackage;
    private ExplorerServiceHelper helper;
    private KieModuleService moduleService;

    public FolderListingResolver() {
    }

    @Inject
    public FolderListingResolver(KieModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public FolderListing resolve(FolderItem selectedItem, Module selectedModule, Package selectedPackage, ExplorerServiceHelper helper, ActiveOptions options) {
        this.init(selectedItem, selectedModule, selectedPackage, helper);
        return this.getFolderListing(options);
    }

    private void init(FolderItem selectedItem, Module selectedModule, Package selectedPackage, ExplorerServiceHelper helper) {
        this.selectedItem = selectedItem;
        this.selectedModule = selectedModule;
        this.selectedPackage = selectedPackage;
        this.helper = helper;
    }

    private FolderListing getFolderListing(ActiveOptions options) {
        FolderListing result = this.selectedItem == null ? (options.contains(Option.BUSINESS_CONTENT) ? new FolderListing(this.helper.toFolderItem(this.getDefaultPackage()), this.helper.getItems(this.getDefaultPackage(), options), this.getSegments()) : this.helper.getFolderListing(this.selectedModule.getRootPath(), options)) : this.helper.getFolderListing(this.selectedItem, options);
        if (this.selectedPackage != null && result == null) {
            result = new FolderListing(this.helper.toFolderItem(this.selectedPackage), this.helper.getItems(this.selectedPackage, options), this.helper.getPackageSegments(this.selectedPackage));
        }
        return result;
    }

    private Package getDefaultPackage() {
        Package defaultPackage = this.selectedPackage == null ? this.moduleService.resolveDefaultPackage(this.selectedModule) : this.selectedPackage;
        return defaultPackage;
    }

    private List<FolderItem> getSegments() {
        if (this.selectedPackage == null) {
            return Collections.emptyList();
        }
        return this.helper.getPackageSegments(this.selectedPackage);
    }
}

