/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.kie.soup.commons.util.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.exception.ClientNotFoundException;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.OperationFailedException;
import org.uberfire.ext.security.management.api.exception.RealmManagementNotAuthorizedException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.impl.SearchRequestImpl;
import org.uberfire.ext.security.management.impl.UserAttributeImpl;
import org.uberfire.ext.security.management.keycloak.client.ClientFactory;
import org.uberfire.ext.security.management.keycloak.client.Keycloak;
import org.uberfire.ext.security.management.keycloak.client.resource.RealmResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleMappingResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleScopeResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RolesResource;
import org.uberfire.ext.security.management.keycloak.client.resource.UserResource;
import org.uberfire.ext.security.management.keycloak.client.resource.UsersResource;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

public abstract class BaseKeyCloakManager {
    static final int STATUS_NOT_AUTHORIZED = 403;
    protected static final String ATTRIBUTE_USER_ID = "user.id";
    protected static final String ATTRIBUTE_USER_FIRST_NAME = "user.firstName";
    protected static final String ATTRIBUTE_USER_LAST_NAME = "user.lastName";
    protected static final String ATTRIBUTE_USER_ENABLED = "user.enabled";
    protected static final String ATTRIBUTE_USER_EMAIL = "user.email";
    protected static final String ATTRIBUTE_USER_EMAIL_VERIFIED = "user.isEmailVerified";
    protected static final UserManager.UserAttribute USER_ID = new UserAttributeImpl("user.id", true, false, null);
    protected static final UserManager.UserAttribute USER_FIST_NAME = new UserAttributeImpl("user.firstName", true, true, "First name");
    protected static final UserManager.UserAttribute USER_LAST_NAME = new UserAttributeImpl("user.lastName", true, true, "Last name");
    protected static final UserManager.UserAttribute USER_ENABLED = new UserAttributeImpl("user.enabled", true, true, "true");
    protected static final UserManager.UserAttribute USER_EMAIL = new UserAttributeImpl("user.email", false, true, "");
    protected static final UserManager.UserAttribute USER_EMAIL_VERIFIED = new UserAttributeImpl("user.isEmailVerified", false, true, "false");
    protected static final Collection<UserManager.UserAttribute> USER_ATTRIBUTES = Arrays.asList(USER_ID, USER_FIST_NAME, USER_LAST_NAME, USER_ENABLED, USER_EMAIL, USER_EMAIL_VERIFIED);
    private static final Logger LOG = LoggerFactory.getLogger(BaseKeyCloakManager.class);
    protected ClientFactory factory;

    protected void init(ClientFactory factory) {
        this.factory = factory;
    }

    protected synchronized Keycloak getKeyCloakInstance() {
        return this.factory.get();
    }

    protected void consumeRealm(Consumer<RealmResource> consumer) {
        try {
            consumer.accept(this.getRealmResource());
        }
        catch (ClientResponseFailure e) {
            if (403 == e.getResponse().getResponseStatus().getStatusCode()) {
                throw new RealmManagementNotAuthorizedException(this.getKeyCloakInstance().getRealm());
            }
            throw new SecurityManagementException((Throwable)e);
        }
    }

    private RealmResource getRealmResource() {
        return this.getKeyCloakInstance().realm();
    }

    protected AbstractEntityManager.SearchRequest getSearchRequest(AbstractEntityManager.SearchRequest request) {
        return request != null ? request : new SearchRequestImpl();
    }

    protected User createUser(UserRepresentation userRepresentation) {
        return this.createUser(userRepresentation, null, null);
    }

    protected User createUser(UserRepresentation userRepresentation, Set<Group> groups, Set<Role> roles) {
        if (userRepresentation != null) {
            String username = userRepresentation.getUsername();
            User user = SecurityManagementUtils.createUser((String)username, groups, roles);
            this.fillUserAttributes(user, userRepresentation);
            return user;
        }
        return null;
    }

    protected Group createGroup(RoleRepresentation roleRepresentation) {
        if (roleRepresentation != null) {
            String name = roleRepresentation.getName();
            Group group = this.createGroup(name);
            return group;
        }
        return null;
    }

    protected Group createGroup(String name) {
        if (name != null) {
            Group group = SecurityManagementUtils.createGroup((String)name);
            return group;
        }
        return null;
    }

    protected Set[] getUserGroupsAndRoles(RoleMappingResource roleMappingResource) {
        List<RoleRepresentation> roles;
        if (roleMappingResource != null && (roles = this.getRolesScopeResource(roleMappingResource, this.getKeyCloakInstance().getUseRoleResourceMappings()).listEffective()) != null && !roles.isEmpty()) {
            HashSet _groups = new HashSet();
            HashSet _roles = new HashSet();
            Set registeredRoles = SecurityManagementUtils.getRegisteredRoleNames();
            for (RoleRepresentation roleRepresentation : roles) {
                if (roleRepresentation == null) continue;
                String name = roleRepresentation.getName();
                SecurityManagementUtils.populateGroupOrRoles((String)name, (Set)registeredRoles, _groups, _roles);
            }
            return new Set[]{_groups, _roles};
        }
        return null;
    }

    protected void fillUserAttributes(User user, UserRepresentation userRepresentation) {
        String userId = userRepresentation.getId();
        String firstName = userRepresentation.getFirstName();
        String lastName = userRepresentation.getLastName();
        String email = userRepresentation.getEmail();
        boolean isEmailVerified = userRepresentation.isEmailVerified();
        boolean isEnabled = userRepresentation.isEnabled();
        user.setProperty(ATTRIBUTE_USER_ID, userId);
        user.setProperty(ATTRIBUTE_USER_FIRST_NAME, firstName);
        user.setProperty(ATTRIBUTE_USER_LAST_NAME, lastName);
        user.setProperty(ATTRIBUTE_USER_EMAIL, email);
        user.setProperty(ATTRIBUTE_USER_EMAIL_VERIFIED, Boolean.toString(isEmailVerified));
        user.setProperty(ATTRIBUTE_USER_ENABLED, Boolean.toString(isEnabled));
        Map attrs = userRepresentation.getAttributes();
        if (attrs != null && !attrs.isEmpty()) {
            for (Map.Entry entry : attrs.entrySet()) {
                String v = entry.getValue() != null ? String.join((CharSequence)", ", (Iterable)entry.getValue()) : null;
                user.setProperty((String)entry.getKey(), v);
            }
        }
    }

    protected void fillUserRepresentationAttributes(User user, UserRepresentation userRepresentation) {
        String username = user.getIdentifier();
        userRepresentation.setUsername(username);
        Map props = user.getProperties();
        if (props != null && !props.isEmpty()) {
            for (Map.Entry entry : props.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (ATTRIBUTE_USER_ID.equals(key)) {
                    userRepresentation.setId(value);
                    continue;
                }
                if (ATTRIBUTE_USER_FIRST_NAME.equals(key)) {
                    userRepresentation.setFirstName(value);
                    continue;
                }
                if (ATTRIBUTE_USER_LAST_NAME.equals(key)) {
                    userRepresentation.setLastName(value);
                    continue;
                }
                if (ATTRIBUTE_USER_EMAIL.equals(key)) {
                    userRepresentation.setEmail(value);
                    continue;
                }
                if (ATTRIBUTE_USER_EMAIL_VERIFIED.equals(key)) {
                    userRepresentation.setEmailVerified(Boolean.valueOf(value));
                    continue;
                }
                if (ATTRIBUTE_USER_ENABLED.equals(key)) {
                    userRepresentation.setEnabled(Boolean.valueOf(value));
                    continue;
                }
                userRepresentation.singleAttribute(key, value);
            }
        }
        ArrayList<String> keycloakRoles = new ArrayList<String>();
        for (Group group : user.getGroups()) {
            keycloakRoles.add(group.getName());
        }
        for (Role role : user.getRoles()) {
            keycloakRoles.add(role.getName());
        }
        if (this.getKeyCloakInstance().getUseRoleResourceMappings().booleanValue()) {
            userRepresentation.setClientRoles(new Maps.Builder().put((Object)this.getKeyCloakInstance().getResource(), keycloakRoles).build());
        } else {
            userRepresentation.setRealmRoles(keycloakRoles);
        }
    }

    protected UserResource getUserResource(UsersResource usersResource, String username) {
        List<UserRepresentation> userRepresentations = usersResource.search(username, null, null, null, 0, 1);
        if (userRepresentations == null || userRepresentations.isEmpty()) {
            throw new UserNotFoundException(username);
        }
        String id = userRepresentations.get(0).getId();
        return usersResource.get(id);
    }

    protected RoleRepresentation getRoleRepresentation(String name, RoleResource roleResource) {
        if (roleResource != null) {
            try {
                return roleResource.toRepresentation();
            }
            catch (NotFoundException e) {
                throw new GroupNotFoundException(name);
            }
            catch (ClientResponseFailure clientResponseFailure) {
                int status = clientResponseFailure.getResponse().getResponseStatus().getStatusCode();
                if (404 == status) {
                    throw new GroupNotFoundException(name);
                }
            }
            catch (Exception e) {
                throw new SecurityManagementException((Throwable)e);
            }
        }
        throw new GroupNotFoundException(name);
    }

    protected void handleResponse(ClientResponse response) {
        if (response != null) {
            int status = response.getStatus();
            response.releaseConnection();
            if (status >= 400) {
                throw new OperationFailedException(status, "Operation failed. See server log messages.");
            }
        }
    }

    protected RolesResource getRolesResource(RealmResource realmResource, boolean useClientRoles) {
        if (useClientRoles) {
            return realmResource.clients().get(this.getClientIdByName(realmResource)).roles();
        }
        return realmResource.roles();
    }

    protected RoleScopeResource getRolesScopeResource(RoleMappingResource roleMappingResource, boolean useClientRoles) {
        if (useClientRoles) {
            return roleMappingResource.clientLevel(this.getClientIdByName(this.getRealmResource()));
        }
        return roleMappingResource.realmLevel();
    }

    protected String getClientIdByName(RealmResource realmResource) {
        List<ClientRepresentation> clientResource = realmResource.clients().findByClientId(this.getKeyCloakInstance().getResource());
        if (!clientResource.isEmpty()) {
            return clientResource.get(0).getId();
        }
        throw new ClientNotFoundException(this.getKeyCloakInstance().getResource());
    }
}

