/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak;

import javax.enterprise.context.Dependent;
import javax.servlet.http.HttpServletRequest;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.keycloak.BaseClientFactory;
import org.uberfire.ext.security.management.keycloak.client.Keycloak;
import org.uberfire.ext.security.management.keycloak.client.auth.adapter.KCAdapterContextTokenManager;

@Dependent
public class KCAdapterClientFactory
extends BaseClientFactory {
    private Keycloak client;

    @Override
    public Keycloak get() {
        assert (this.client != null);
        return this.client;
    }

    public void init(ConfigProperties config, HttpServletRequest request) {
        ConfigProperties.ConfigProperty authServer = config.get("org.uberfire.ext.security.management.keycloak.authServer", "http://localhost:8080/auth");
        ConfigProperties.ConfigProperty useRoleResourceMappings = config.get("org.uberfire.ext.security.management.keycloak.use-resource-role-mappings", "false");
        KCAdapterContextTokenManager tokenManager = new KCAdapterContextTokenManager(request);
        this.client = Keycloak.getInstance(authServer.getValue(), tokenManager.getRealm(), tokenManager.getResource(), useRoleResourceMappings.getBooleanValue(), tokenManager);
    }
}

