/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak.client;

import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.uberfire.ext.security.management.keycloak.client.auth.BearerAuthenticationInterceptor;
import org.uberfire.ext.security.management.keycloak.client.auth.TokenManager;
import org.uberfire.ext.security.management.keycloak.client.resource.RealmResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RealmsResource;

public class Keycloak {
    private final String serverUrl;
    private final String realm;
    private final String resource;
    private final Boolean useRoleResourceMappings;
    private final ClientRequestFactory clientRequestFactory;

    Keycloak(String serverUrl, String realm, String resource, Boolean useRoleResourceMappings, TokenManager tokenManager) {
        this.serverUrl = serverUrl;
        this.realm = realm;
        this.resource = resource;
        this.useRoleResourceMappings = useRoleResourceMappings;
        this.clientRequestFactory = new ClientRequestFactory(UriBuilder.fromUri((String)serverUrl).build(new Object[0]));
        ResteasyProviderFactory.getInstance().getClientExecutionInterceptorRegistry().register((Object)new BearerAuthenticationInterceptor(tokenManager));
    }

    public static Keycloak getInstance(String serverUrl, String realm, String resource, Boolean useRoleResourceMappings, TokenManager tokenManager) {
        return new Keycloak(serverUrl, realm, resource, useRoleResourceMappings, tokenManager);
    }

    public RealmResource realm() {
        return ((RealmsResource)this.clientRequestFactory.createProxy(RealmsResource.class)).realm(this.getRealm());
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getRealm() {
        return this.realm;
    }

    public Boolean getUseRoleResourceMappings() {
        return this.useRoleResourceMappings;
    }

    public String getResource() {
        return this.resource;
    }

    public void close() {
    }
}

