/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.service.backend.keystore.impl.storage;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ssh.service.backend.keystore.impl.util.SerializingUtils;
import org.uberfire.ssh.service.backend.keystore.model.KeyMetaData;
import org.uberfire.ssh.service.backend.keystore.model.SSHPublicKey;
import org.uberfire.ssh.service.backend.keystore.util.PublicKeyConverter;

public class UserSSHKeyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserSSHKeyStore.class);
    public static final String DEFAULT_KEY_NAME = "Key #{0}";
    private static final String PUBLIC_KEY_EXTENSION = ".pub";
    private static final String METADATA_PREFFIX = ".";
    private static final String METADATA_EXTENSION = ".pub.meta";
    private final String user;
    private final Path rootPath;
    private List<SSHPublicKey> keys = new ArrayList<SSHPublicKey>();

    public UserSSHKeyStore(String user, Path rootPath) {
        this.user = user;
        this.rootPath = rootPath.resolve(user);
        this.init();
    }

    private void init() {
        File rootFile = this.rootPath.toFile();
        if (rootFile.exists()) {
            Stream.of(rootFile.listFiles()).filter(File::isFile).filter(file -> file.getName().endsWith(PUBLIC_KEY_EXTENSION)).map(this::loadKey).filter(Objects::nonNull).collect(Collectors.toCollection(() -> this.keys));
        } else {
            rootFile.mkdirs();
        }
    }

    public String getUser() {
        return this.user;
    }

    public Collection<SSHPublicKey> getUserKeys() {
        return this.keys;
    }

    public void addUserKey(SSHPublicKey key) {
        Optional<SSHPublicKey> optional = this.getKeyById(key.getId());
        if (optional.isPresent()) {
            SSHPublicKey oldKey = optional.get();
            this.removeUserKey(oldKey);
        }
        this.keys.add(key);
        this.writeKey(key);
    }

    public void removeUserKey(SSHPublicKey oldKey) {
        Optional<SSHPublicKey> optional = this.getKeyById(oldKey.getId());
        if (optional.isPresent()) {
            SSHPublicKey key = optional.get();
            this.keys.remove(key);
            FileUtils.deleteQuietly((File)this.rootPath.resolve(this.getKeyFileName(oldKey.getId())).toFile());
            FileUtils.deleteQuietly((File)this.rootPath.resolve(this.getMetadataFileName(oldKey.getId())).toFile());
        }
    }

    public Optional<SSHPublicKey> getKeyById(String keyId) {
        return this.keys.stream().filter(userKey -> userKey.getId().equals(keyId)).findAny();
    }

    private void writeKey(SSHPublicKey key) {
        File file = this.rootPath.resolve(key.getId() + PUBLIC_KEY_EXTENSION).toFile();
        if (file.exists()) {
            file.delete();
        }
        try {
            this.writeKeyFile(key.getId(), key.getKey());
            this.writeMetaData(key.getId(), key.getMetaData());
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot create public key for user '{}' on file '{}': ", new Object[]{this.user, file.getAbsolutePath(), ex});
        }
    }

    private void writeKeyFile(String id, PublicKey key) throws IOException {
        File fileKey = this.rootPath.resolve(this.getKeyFileName(id)).toFile();
        if (fileKey.exists()) {
            fileKey.delete();
        }
        fileKey.createNewFile();
        FileUtils.write((File)fileKey, (CharSequence)PublicKeyConverter.fromPublicKey((PublicKey)key), (Charset)Charset.defaultCharset());
    }

    private SSHPublicKey loadKey(File keyFile) {
        try {
            String fileName = keyFile.getName();
            String id = fileName.substring(0, fileName.lastIndexOf(PUBLIC_KEY_EXTENSION));
            String keyContent = FileUtils.readFileToString((File)keyFile, (Charset)Charset.defaultCharset());
            return new SSHPublicKey(id, PublicKeyConverter.fromString((String)keyContent), this.readMetaData(id));
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot read public key for user '{}' on file '{}': ", new Object[]{this.user, keyFile.getAbsolutePath(), ex});
            return null;
        }
    }

    private void writeMetaData(String id, KeyMetaData metaData) throws IOException {
        File file = this.rootPath.resolve(this.getMetadataFileName(id)).toFile();
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        FileUtils.write((File)file, (CharSequence)SerializingUtils.readMetaData(metaData), (Charset)Charset.defaultCharset());
    }

    private KeyMetaData readMetaData(String id) throws IOException {
        KeyMetaData metaData;
        File metaDataFile = this.rootPath.resolve(this.getMetadataFileName(id)).toFile();
        if (!metaDataFile.exists()) {
            metaDataFile.createNewFile();
            String keyName = MessageFormat.format(DEFAULT_KEY_NAME, id);
            metaData = new KeyMetaData(keyName, new Date());
            this.writeMetaData(id, metaData);
        } else {
            String metaDataContent = FileUtils.readFileToString((File)metaDataFile, (Charset)Charset.defaultCharset());
            metaData = SerializingUtils.readMetaData(metaDataContent);
        }
        return metaData;
    }

    private String getKeyFileName(String id) {
        return id + PUBLIC_KEY_EXTENSION;
    }

    private String getMetadataFileName(String id) {
        return METADATA_PREFFIX + id + METADATA_EXTENSION;
    }
}

