/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.events;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.events.IntermediateCatchEventConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BoundaryEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.CatchEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.BaseCatchingIntermediateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateErrorEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateLinkEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.common.ConditionExpression;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.CircleDimensionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.CancelActivity;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.conditional.CancellingConditionalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.CancellingErrorEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.ErrorRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.CancellingEscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.link.LinkEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.link.LinkRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.CancellingMessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.CancellingSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.CancellingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettings;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettingsValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class IntermediateCatchEventConverterTest {
    private static final String UUID = "CATCHING EVENT UUID";
    private static final String NAME = "CATCHING EVENT NAME";
    private static final String DOCUMENTATION = "CATCHING EVENT DOCUMENTATION";
    private static final String ASSIGNMENTS_INFO = "Years of Service:Integer||Data Test:Boolean||[din]Years of Service=35,[dout]Data Test->BooleanTest";
    private static final boolean CANCEL_ACTIVITY = false;
    private BoundaryEventPropertyWriter boundaryEventPropertyWriter;
    private CatchEventPropertyWriter catchEventPropertyWriter;
    private PropertyWriterFactory propertyWriterFactory;
    private BPMNGeneralSet generalSet;
    private AssignmentsInfo assignmentsInfo;
    private DataIOSet dataIOSet;
    private SLADueDate slaDueDate;
    private ErrorRef errorRef;
    private SignalRef signalRef;
    private LinkRef linkRef;
    private TimerSettingsValue timerSettingsValue;
    private TimerSettings timerSettings;
    private MessageRef messageRef;
    private ScriptTypeValue scriptTypeValue;
    private ConditionExpression conditionExpression;
    private EscalationRef escalationRef;
    private IntermediateCatchEventConverter tested;

    @Before
    public void setUp() {
        BoundaryEvent boundaryEvent = Factories.bpmn2.createBoundaryEvent();
        boundaryEvent.setId("boundaryEventID");
        this.boundaryEventPropertyWriter = (BoundaryEventPropertyWriter)Mockito.spy((Object)new BoundaryEventPropertyWriter(boundaryEvent, (VariableScope)new FlatVariableScope(), new HashSet()));
        Mockito.when((Object)this.boundaryEventPropertyWriter.getFlowElement()).thenReturn(Mockito.spy(FlowElement.class));
        IntermediateCatchEvent catchEvent = Factories.bpmn2.createIntermediateCatchEvent();
        catchEvent.setId("catchEventID");
        this.catchEventPropertyWriter = (CatchEventPropertyWriter)Mockito.spy((Object)new CatchEventPropertyWriter((CatchEvent)catchEvent, (VariableScope)new FlatVariableScope(), new HashSet()));
        this.propertyWriterFactory = (PropertyWriterFactory)Mockito.spy(PropertyWriterFactory.class);
        Mockito.when((Object)this.propertyWriterFactory.of((BoundaryEvent)ArgumentMatchers.any(BoundaryEvent.class))).thenReturn((Object)this.boundaryEventPropertyWriter);
        Mockito.when((Object)this.propertyWriterFactory.of((CatchEvent)ArgumentMatchers.any(CatchEvent.class))).thenReturn((Object)this.catchEventPropertyWriter);
        this.generalSet = new BPMNGeneralSet(NAME, DOCUMENTATION);
        this.assignmentsInfo = new AssignmentsInfo(ASSIGNMENTS_INFO);
        this.dataIOSet = new DataIOSet(this.assignmentsInfo);
        this.slaDueDate = (SLADueDate)Mockito.mock(SLADueDate.class);
        this.errorRef = (ErrorRef)Mockito.mock(ErrorRef.class);
        this.signalRef = (SignalRef)Mockito.mock(SignalRef.class);
        this.linkRef = (LinkRef)Mockito.mock(LinkRef.class);
        this.timerSettingsValue = (TimerSettingsValue)Mockito.mock(TimerSettingsValue.class);
        this.timerSettings = new TimerSettings(this.timerSettingsValue);
        this.messageRef = (MessageRef)Mockito.mock(MessageRef.class);
        this.scriptTypeValue = (ScriptTypeValue)Mockito.mock(ScriptTypeValue.class);
        this.conditionExpression = new ConditionExpression(this.scriptTypeValue);
        this.escalationRef = (EscalationRef)Mockito.mock(EscalationRef.class);
        this.tested = (IntermediateCatchEventConverter)Mockito.spy((Object)new IntermediateCatchEventConverter(this.propertyWriterFactory));
    }

    @Test
    public void constructor() {
        Assert.assertEquals((Object)this.propertyWriterFactory, (Object)this.tested.propertyWriterFactory);
    }

    @Test
    public void toFlowElement() {
        Node intermediateErrorEventCatchingNode = this.createIntermediateErrorEventCatchingNode();
        Node intermediateSignalEventCatchingNode = this.createIntermediateSignalEventCatchingNode();
        Node intermediateLinkEventCatchingNode = this.createIntermediateLinkEventCatchingNode();
        Node intermediateTimerEventCatchingNode = this.createIntermediateTimerEventCatchingNode();
        Node intermediateMessageEventCatchingNode = this.createIntermediateMessageEventCatchingNode();
        Node intermediateConditionalEventCatchingNode = this.createIntermediateConditionalEventCatchingNode();
        Node intermediateEscalationEventCatchingNode = this.createIntermediateEscalationEventCatchingNode();
        Node intermediateCompensationEventCatchingNode = this.createIntermediateCompensationEventCatchingNode();
        this.tested.toFlowElement(intermediateErrorEventCatchingNode);
        this.tested.toFlowElement(intermediateSignalEventCatchingNode);
        this.tested.toFlowElement(intermediateLinkEventCatchingNode);
        this.tested.toFlowElement(intermediateTimerEventCatchingNode);
        this.tested.toFlowElement(intermediateMessageEventCatchingNode);
        this.tested.toFlowElement(intermediateConditionalEventCatchingNode);
        this.tested.toFlowElement(intermediateEscalationEventCatchingNode);
        this.tested.toFlowElement(intermediateCompensationEventCatchingNode);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).errorEvent(intermediateErrorEventCatchingNode);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).signalEvent(intermediateSignalEventCatchingNode);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).linkEvent(intermediateLinkEventCatchingNode);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).timerEvent(intermediateTimerEventCatchingNode);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).messageEvent(intermediateMessageEventCatchingNode);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).conditionalEvent(intermediateConditionalEventCatchingNode);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).escalationEvent(intermediateEscalationEventCatchingNode);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).compensationEvent(intermediateCompensationEventCatchingNode);
    }

    @Test
    public void errorEvent() {
        Node node = this.createIntermediateErrorEventCatchingNode();
        PropertyWriter propertyWriter = this.tested.errorEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).setCancelActivity(Boolean.valueOf(false));
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addSlaDueDate(this.slaDueDate);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addError(this.errorRef);
        this.verifyCommonProperties(node);
    }

    @Test
    public void signalEvent() {
        Node node = this.createIntermediateSignalEventCatchingNode();
        PropertyWriter propertyWriter = this.tested.signalEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).setCancelActivity(Boolean.valueOf(false));
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addSlaDueDate(this.slaDueDate);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addSignal(this.signalRef);
        this.verifyCommonProperties(node);
    }

    @Test
    public void linkEvent() {
        Node node = this.createIntermediateLinkEventCatchingNode();
        PropertyWriter propertyWriter = this.tested.linkEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addLink(this.linkRef);
        this.verifyCommonProperties(node);
    }

    @Test
    public void timerEvent() {
        Node node = this.createIntermediateTimerEventCatchingNode();
        PropertyWriter propertyWriter = this.tested.timerEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).setCancelActivity(Boolean.valueOf(false));
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addSlaDueDate(this.slaDueDate);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addTimer(this.timerSettings);
        this.verifyCommonProperties(node);
    }

    @Test
    public void messageEvent() {
        Node node = this.createIntermediateMessageEventCatchingNode();
        PropertyWriter propertyWriter = this.tested.messageEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).setCancelActivity(Boolean.valueOf(false));
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addSlaDueDate(this.slaDueDate);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addMessage(this.messageRef);
        this.verifyCommonProperties(node);
    }

    @Test
    public void conditionalEvent() {
        Node node = this.createIntermediateConditionalEventCatchingNode();
        PropertyWriter propertyWriter = this.tested.conditionalEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).setCancelActivity(Boolean.valueOf(false));
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addSlaDueDate(this.slaDueDate);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addCondition(this.conditionExpression);
        this.verifyCommonProperties(node);
    }

    @Test
    public void escalationEvent() {
        Node node = this.createIntermediateEscalationEventCatchingNode();
        PropertyWriter propertyWriter = this.tested.escalationEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).setCancelActivity(Boolean.valueOf(false));
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addSlaDueDate(this.slaDueDate);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addEscalation(this.escalationRef);
        this.verifyCommonProperties(node);
    }

    @Test
    public void compensationEvent() {
        Node node = this.createIntermediateCompensationEventCatchingNode();
        PropertyWriter propertyWriter = this.tested.compensationEvent(node);
        Assert.assertNotNull((Object)propertyWriter);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addSlaDueDate(this.slaDueDate);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).addCompensation();
        this.verifyCommonProperties(node);
    }

    @Test
    public void createCatchEventPropertyWriter() {
        Node<View<BaseCatchingIntermediateEvent>, Edge> node1 = IntermediateCatchEventConverterTest.mockNode();
        CatchEventPropertyWriter result1 = this.tested.createCatchEventPropertyWriter(node1);
        Node<View<BaseCatchingIntermediateEvent>, Edge> node2 = IntermediateCatchEventConverterTest.mockDockedNode((Node)Mockito.mock(Node.class), null);
        CatchEventPropertyWriter result2 = this.tested.createCatchEventPropertyWriter(node2);
        ((PropertyWriterFactory)Mockito.verify((Object)this.propertyWriterFactory)).of((BoundaryEvent)ArgumentMatchers.any(BoundaryEvent.class));
        ((PropertyWriterFactory)Mockito.verify((Object)this.propertyWriterFactory)).of((CatchEvent)ArgumentMatchers.any(IntermediateCatchEvent.class));
        Assert.assertFalse((boolean)(result1 instanceof BoundaryEventPropertyWriter));
        Assert.assertTrue((boolean)(result1 instanceof CatchEventPropertyWriter));
        Assert.assertTrue((boolean)(result2 instanceof BoundaryEventPropertyWriter));
    }

    private void verifyCommonProperties(Node node) {
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).getFlowElement();
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).setAbsoluteBounds(node);
        ((FlowElement)Mockito.verify((Object)this.boundaryEventPropertyWriter.getFlowElement())).setId(UUID);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).setName(NAME);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).setDocumentation(DOCUMENTATION);
        ((BoundaryEventPropertyWriter)Mockito.verify((Object)this.boundaryEventPropertyWriter)).setAssignmentsInfo(this.assignmentsInfo);
    }

    private Node createIntermediateErrorEventCatchingNode() {
        CancellingErrorEventExecutionSet executionSet = new CancellingErrorEventExecutionSet(new CancelActivity(Boolean.valueOf(false)), this.slaDueDate, this.errorRef);
        IntermediateErrorEventCatching eventCatching = new IntermediateErrorEventCatching(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseCatchingIntermediateEvent>, Edge> dockNode = IntermediateCatchEventConverterTest.mockNode();
        Node<View<BaseCatchingIntermediateEvent>, Edge> node = IntermediateCatchEventConverterTest.mockDockedNode(dockNode, (BaseCatchingIntermediateEvent)eventCatching);
        return node;
    }

    private Node createIntermediateSignalEventCatchingNode() {
        CancellingSignalEventExecutionSet executionSet = new CancellingSignalEventExecutionSet(new CancelActivity(Boolean.valueOf(false)), this.slaDueDate, this.signalRef);
        IntermediateSignalEventCatching eventCatching = new IntermediateSignalEventCatching(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseCatchingIntermediateEvent>, Edge> dockNode = IntermediateCatchEventConverterTest.mockNode();
        Node<View<BaseCatchingIntermediateEvent>, Edge> node = IntermediateCatchEventConverterTest.mockDockedNode(dockNode, (BaseCatchingIntermediateEvent)eventCatching);
        return node;
    }

    private Node createIntermediateLinkEventCatchingNode() {
        LinkEventExecutionSet executionSet = new LinkEventExecutionSet(this.linkRef);
        IntermediateLinkEventCatching eventCatching = new IntermediateLinkEventCatching(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseCatchingIntermediateEvent>, Edge> dockNode = IntermediateCatchEventConverterTest.mockNode();
        Node<View<BaseCatchingIntermediateEvent>, Edge> node = IntermediateCatchEventConverterTest.mockDockedNode(dockNode, (BaseCatchingIntermediateEvent)eventCatching);
        return node;
    }

    private Node createIntermediateTimerEventCatchingNode() {
        CancellingTimerEventExecutionSet executionSet = new CancellingTimerEventExecutionSet(new CancelActivity(Boolean.valueOf(false)), this.slaDueDate, this.timerSettings);
        IntermediateTimerEvent eventCatching = new IntermediateTimerEvent(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseCatchingIntermediateEvent>, Edge> dockNode = IntermediateCatchEventConverterTest.mockNode();
        Node<View<BaseCatchingIntermediateEvent>, Edge> node = IntermediateCatchEventConverterTest.mockDockedNode(dockNode, (BaseCatchingIntermediateEvent)eventCatching);
        return node;
    }

    private Node createIntermediateMessageEventCatchingNode() {
        CancellingMessageEventExecutionSet executionSet = new CancellingMessageEventExecutionSet(new CancelActivity(Boolean.valueOf(false)), this.slaDueDate, this.messageRef);
        IntermediateMessageEventCatching eventCatching = new IntermediateMessageEventCatching(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseCatchingIntermediateEvent>, Edge> dockNode = IntermediateCatchEventConverterTest.mockNode();
        Node<View<BaseCatchingIntermediateEvent>, Edge> node = IntermediateCatchEventConverterTest.mockDockedNode(dockNode, (BaseCatchingIntermediateEvent)eventCatching);
        return node;
    }

    private Node createIntermediateConditionalEventCatchingNode() {
        CancellingConditionalEventExecutionSet executionSet = new CancellingConditionalEventExecutionSet(new CancelActivity(Boolean.valueOf(false)), this.slaDueDate, this.conditionExpression);
        IntermediateConditionalEvent eventCatching = new IntermediateConditionalEvent(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseCatchingIntermediateEvent>, Edge> dockNode = IntermediateCatchEventConverterTest.mockNode();
        Node<View<BaseCatchingIntermediateEvent>, Edge> node = IntermediateCatchEventConverterTest.mockDockedNode(dockNode, (BaseCatchingIntermediateEvent)eventCatching);
        return node;
    }

    private Node createIntermediateEscalationEventCatchingNode() {
        CancellingEscalationEventExecutionSet executionSet = new CancellingEscalationEventExecutionSet(new CancelActivity(Boolean.valueOf(false)), this.slaDueDate, this.escalationRef);
        IntermediateEscalationEvent eventCatching = new IntermediateEscalationEvent(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseCatchingIntermediateEvent>, Edge> dockNode = IntermediateCatchEventConverterTest.mockNode();
        Node<View<BaseCatchingIntermediateEvent>, Edge> node = IntermediateCatchEventConverterTest.mockDockedNode(dockNode, (BaseCatchingIntermediateEvent)eventCatching);
        return node;
    }

    private Node createIntermediateCompensationEventCatchingNode() {
        BaseCancellingEventExecutionSet executionSet = new BaseCancellingEventExecutionSet(new CancelActivity(Boolean.valueOf(false)), this.slaDueDate);
        IntermediateCompensationEvent eventCatching = new IntermediateCompensationEvent(this.generalSet, (BackgroundSet)Mockito.mock(BackgroundSet.class), (FontSet)Mockito.mock(FontSet.class), (CircleDimensionSet)Mockito.mock(CircleDimensionSet.class), this.dataIOSet, executionSet);
        Node<View<BaseCatchingIntermediateEvent>, Edge> dockNode = IntermediateCatchEventConverterTest.mockNode();
        Node<View<BaseCatchingIntermediateEvent>, Edge> node = IntermediateCatchEventConverterTest.mockDockedNode(dockNode, (BaseCatchingIntermediateEvent)eventCatching);
        return node;
    }

    private static Node<View<BaseCatchingIntermediateEvent>, Edge> mockNode() {
        Node node = (Node)Mockito.mock(Node.class);
        View view = (View)Mockito.mock(View.class);
        Bound ul = new Bound(Double.valueOf(0.0), Double.valueOf(100.0));
        Bound lr = new Bound(Double.valueOf(200.0), Double.valueOf(0.0));
        Bounds bounds = new Bounds(ul, lr);
        Mockito.when((Object)node.getContent()).thenReturn((Object)view);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        return node;
    }

    private static Node<View<BaseCatchingIntermediateEvent>, Edge> mockDockedNode(Node dockSourceNode, BaseCatchingIntermediateEvent event) {
        Dock dockContent = (Dock)Mockito.mock(Dock.class);
        Edge edge = (Edge)Mockito.mock(Edge.class);
        List<Edge> inEdges = Collections.singletonList(edge);
        Node node = (Node)Mockito.mock(Node.class);
        View view = (View)Mockito.mock(View.class);
        Bound ul = new Bound(Double.valueOf(0.0), Double.valueOf(100.0));
        Bound lr = new Bound(Double.valueOf(200.0), Double.valueOf(0.0));
        Bounds bounds = new Bounds(ul, lr);
        Mockito.when((Object)node.getUUID()).thenReturn((Object)UUID);
        Mockito.when((Object)node.getInEdges()).thenReturn(inEdges);
        Mockito.when((Object)node.getContent()).thenReturn((Object)view);
        Mockito.when((Object)edge.getContent()).thenReturn((Object)dockContent);
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)dockSourceNode);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        Mockito.when((Object)view.getDefinition()).thenReturn((Object)event);
        return node;
    }
}

