/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.processes;

import java.util.HashMap;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.ElementContainer;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.FlowElementPostConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.processes.ProcessConverterDelegate;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EndCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateErrorEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.ScriptTask;
import org.kie.workbench.common.stunner.bpmn.definition.StartNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.UserTask;
import org.kie.workbench.common.stunner.core.TestingGraphInstanceBuilder2;
import org.kie.workbench.common.stunner.core.TestingGraphMockHandler;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ProcessConverterDelegateTest {
    @Captor
    private ArgumentCaptor<Node<View<? extends BPMNViewDefinition>, ?>> nodeCaptor;

    @Test
    public void convertDockedEdges() {
        GraphNodeStoreImpl nodes = new GraphNodeStoreImpl();
        GraphImpl g = new GraphImpl("g", (GraphNodeStore)nodes);
        NodeImpl root = new NodeImpl("root");
        BPMNDiagramImpl bpmnDiagram = new BPMNDiagramImpl();
        root.setContent((Object)new ViewImpl((Object)bpmnDiagram, Bounds.create()));
        g.addNode((Node)root);
        NodeImpl n = new NodeImpl("n");
        EmbeddedSubprocess subProcessNode = new EmbeddedSubprocess();
        n.setContent((Object)new ViewImpl((Object)subProcessNode, Bounds.create()));
        g.addNode((Node)n);
        NodeImpl e = new NodeImpl("e");
        IntermediateErrorEventCatching intermediateErrorEventCatching = new IntermediateErrorEventCatching();
        e.setContent((Object)new ViewImpl((Object)intermediateErrorEventCatching, Bounds.create()));
        g.addNode((Node)e);
        EdgeImpl edge = new EdgeImpl("edge");
        Dock dock = new Dock();
        edge.setContent((Object)dock);
        n.getOutEdges().add(edge);
        edge.setSourceNode((Node)n);
        e.getInEdges().add(edge);
        edge.setTargetNode((Node)e);
        DefinitionsBuildingContext ctx = new DefinitionsBuildingContext((Graph)g);
        PropertyWriterFactory pwFactory = new PropertyWriterFactory();
        ConverterFactory factory = new ConverterFactory(ctx, pwFactory);
        MyProcessConverter abstractProcessConverter = new MyProcessConverter(factory);
        ProcessPropertyWriter p = pwFactory.of(Factories.bpmn2.createProcess());
        Assertions.assertThatCode(() -> {
            abstractProcessConverter.convertChildNodes((ElementContainer)p, ctx);
            abstractProcessConverter.convertEdges((ElementContainer)p, ctx);
        }).doesNotThrowAnyException();
    }

    @Test
    public void testPostConvertNodes() {
        TestingGraphMockHandler graphTestHandler = new TestingGraphMockHandler();
        BPMNDiagramImpl bpmnDiagram = new BPMNDiagramImpl();
        StartNoneEvent level0StartNode = new StartNoneEvent();
        EndNoneEvent level0EndNode = new EndNoneEvent();
        UserTask level0Node1 = new UserTask();
        UserTask level0Node2 = new UserTask();
        EmbeddedSubprocess level1SubProcess1 = new EmbeddedSubprocess();
        ScriptTask level1Node1 = new ScriptTask();
        IntermediateSignalEventThrowing level1Node2 = new IntermediateSignalEventThrowing();
        AdHocSubprocess level2SubProcess1 = new AdHocSubprocess();
        BusinessRuleTask level2Node1 = new BusinessRuleTask();
        EndCompensationEvent level2Node2 = new EndCompensationEvent();
        TestingGraphInstanceBuilder2.Level2Graph level2Graph = TestingGraphInstanceBuilder2.buildLevel2Graph((TestingGraphMockHandler)graphTestHandler, (Object)bpmnDiagram, (Object)level0StartNode, (Object)level0Node1, (Object)level0Node2, (Object)level0EndNode, (Object)level1SubProcess1, (Object)level1Node1, (Object)level1Node2, (Object)level2SubProcess1, (Object)level2Node1, (Object)level2Node2);
        DefinitionsBuildingContext ctx = new DefinitionsBuildingContext(level2Graph.graph);
        PropertyWriterFactory writerFactory = new PropertyWriterFactory();
        ConverterFactory factory = (ConverterFactory)Mockito.spy((Object)new ConverterFactory(ctx, writerFactory));
        FlowElementPostConverter flowElementPostConverter = (FlowElementPostConverter)Mockito.mock(FlowElementPostConverter.class);
        Mockito.when((Object)factory.flowElementPostConverter()).thenReturn((Object)flowElementPostConverter);
        MyProcessConverter abstractProcessConverter = new MyProcessConverter(factory);
        ProcessPropertyWriter processWriter = writerFactory.of(Factories.bpmn2.createProcess());
        abstractProcessConverter.postConvertChildNodes(processWriter, ctx);
        ((FlowElementPostConverter)Mockito.verify((Object)flowElementPostConverter, (VerificationMode)Mockito.times((int)10))).postConvert((ProcessPropertyWriter)ArgumentMatchers.anyObject(), (BasePropertyWriter)ArgumentMatchers.anyObject(), (Node)this.nodeCaptor.capture());
        HashMap<String, Object> nodes = new HashMap<String, Object>();
        nodes.put(TestingGraphInstanceBuilder2.NODES.LEVEL0_START_NODE.uuid(), level0StartNode);
        nodes.put(TestingGraphInstanceBuilder2.NODES.LEVEL0_NODE1.uuid(), level0Node1);
        nodes.put(TestingGraphInstanceBuilder2.NODES.LEVEL0_NODE2.uuid(), level0Node2);
        nodes.put(TestingGraphInstanceBuilder2.NODES.LEVEL0_END_NODE.uuid(), level0EndNode);
        nodes.put(TestingGraphInstanceBuilder2.NODES.LEVEL1_SUB_PROCESS1.uuid(), level1SubProcess1);
        nodes.put(TestingGraphInstanceBuilder2.NODES.LEVEL1_NODE1.uuid(), level1Node1);
        nodes.put(TestingGraphInstanceBuilder2.NODES.LEVEL1_NODE2.uuid(), level1Node2);
        nodes.put(TestingGraphInstanceBuilder2.NODES.LEVEL2_SUB_PROCESS1.uuid(), level2SubProcess1);
        nodes.put(TestingGraphInstanceBuilder2.NODES.LEVEL2_NODE1.uuid(), level2Node1);
        nodes.put(TestingGraphInstanceBuilder2.NODES.LEVEL2_NODE2.uuid(), level2Node2);
        Assert.assertEquals((long)nodes.size(), (long)this.nodeCaptor.getAllValues().size());
        nodes.entrySet().forEach(entry -> {
            Optional<Node> processed = this.nodeCaptor.getAllValues().stream().filter(captured -> ((String)entry.getKey()).equals(captured.getUUID())).findFirst();
            Assert.assertTrue((String)("Node: " + (String)entry.getKey() + " was not present in result"), (boolean)processed.isPresent());
            Assert.assertEquals(entry.getValue(), (Object)((View)processed.get().getContent()).getDefinition());
        });
    }

    static class MyProcessConverter
    extends ProcessConverterDelegate {
        public MyProcessConverter(ConverterFactory converterFactory) {
            super(converterFactory);
        }
    }
}

