/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.HashSet;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.AbstractBasePropertyWriterTest;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ActivityPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BoundaryEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

public class BoundaryEventPropertyWriterTest
extends AbstractBasePropertyWriterTest<BoundaryEventPropertyWriter, BoundaryEvent> {
    @Mock
    private FeatureMap featureMap;
    @Captor
    private ArgumentCaptor<FeatureMap.Entry> entryCaptor;

    @Override
    protected BoundaryEventPropertyWriter newPropertyWriter(BoundaryEvent baseElement, VariableScope variableScope) {
        return new BoundaryEventPropertyWriter(baseElement, variableScope, new HashSet());
    }

    @Override
    protected BoundaryEvent mockElement() {
        BoundaryEvent eventMock = (BoundaryEvent)Mockito.mock(BoundaryEvent.class);
        Mockito.when((Object)eventMock.getAnyAttribute()).thenReturn((Object)this.featureMap);
        return eventMock;
    }

    @Test
    public void testSetCancelActivityTrue() {
        this.testSetCancelActivity(true);
    }

    @Test
    public void testSetCancelActivityFalse() {
        this.testSetCancelActivity(false);
    }

    private void testSetCancelActivity(boolean value) {
        ((BoundaryEventPropertyWriter)this.propertyWriter).setCancelActivity(Boolean.valueOf(value));
        ((FeatureMap)Mockito.verify((Object)this.featureMap)).add(this.entryCaptor.capture());
        Assert.assertEquals((Object)String.format("drools:boundaryca=%s", value), (Object)((FeatureMap.Entry)this.entryCaptor.getValue()).toString());
        ((BoundaryEvent)Mockito.verify((Object)this.element)).setCancelActivity(value);
    }

    @Test
    public void testSetParentActivity() {
        ActivityPropertyWriter parentActivityWriter = (ActivityPropertyWriter)Mockito.mock(ActivityPropertyWriter.class);
        Activity activity = (Activity)Mockito.mock(Activity.class);
        Mockito.when((Object)parentActivityWriter.getFlowElement()).thenReturn((Object)activity);
        ((BoundaryEventPropertyWriter)this.propertyWriter).setParentActivity(parentActivityWriter);
        ((BoundaryEvent)Mockito.verify((Object)this.element)).setAttachedToRef(activity);
    }

    @Test
    public void testAddEventDefinition() {
        List eventDefinitions = (List)Mockito.mock(List.class);
        Mockito.when((Object)((BoundaryEvent)this.element).getEventDefinitions()).thenReturn((Object)eventDefinitions);
        EventDefinition eventDefinition = (EventDefinition)Mockito.mock(EventDefinition.class);
        ((BoundaryEventPropertyWriter)this.propertyWriter).addEventDefinition(eventDefinition);
        ((List)Mockito.verify((Object)eventDefinitions)).add(eventDefinition);
    }

    @Override
    @Test
    public void testSetAbsoluteBounds() {
        Node<View, ?> node = super.createNode();
        Node<View, ?> dockSourceParentNode = BoundaryEventPropertyWriterTest.mockNode(new Object(), org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)PARENT_ABSOLUTE_X1, (double)PARENT_ABSOLUTE_Y1, (double)PARENT_ABSOLUTE_X2, (double)PARENT_ABSOLUTE_Y2));
        double dockSourceRelativeX1 = 15.0;
        double dockSourceRelativeY1 = 20.0;
        double dockSourceRelativeX2 = 50.0;
        double dockSourceAbsoluteY2 = 45.0;
        Node<View, ?> dockSourceNode = BoundaryEventPropertyWriterTest.mockNode(new Object(), org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)dockSourceRelativeX1, (double)dockSourceRelativeY1, (double)dockSourceRelativeX2, (double)dockSourceAbsoluteY2), dockSourceParentNode);
        Edge dockEdge = (Edge)Mockito.mock(Edge.class);
        Mockito.when((Object)dockEdge.getSourceNode()).thenReturn(dockSourceNode);
        Dock dock = (Dock)Mockito.mock(Dock.class);
        Mockito.when((Object)dockEdge.getContent()).thenReturn((Object)dock);
        node.getInEdges().clear();
        node.getInEdges().add(dockEdge);
        ((BoundaryEventPropertyWriter)this.propertyWriter).setAbsoluteBounds(node);
        Bounds shapeBounds = ((BoundaryEventPropertyWriter)this.propertyWriter).getShape().getBounds();
        org.kie.workbench.common.stunner.core.graph.content.Bounds relativeBounds = ((View)node.getContent()).getBounds();
        double dockSourceAbsoluteX = PARENT_ABSOLUTE_X1 + dockSourceRelativeX1;
        double dockSourceAbsoluteY = PARENT_ABSOLUTE_Y1 + dockSourceRelativeY1;
        Assert.assertEquals((double)(dockSourceAbsoluteX + relativeBounds.getX()), (double)shapeBounds.getX(), (double)0.0);
        Assert.assertEquals((double)(dockSourceAbsoluteY + relativeBounds.getY()), (double)shapeBounds.getY(), (double)0.0);
        Assert.assertEquals((double)relativeBounds.getWidth(), (double)shapeBounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)relativeBounds.getHeight(), (double)shapeBounds.getHeight(), (double)0.0);
        this.verifyDockerInfoWasSet(relativeBounds);
    }

    @Test
    public void testSetAbsoluteBoundsWhenDockedSourceNodeIsNotPresent() {
        Node<View, ?> node = super.createNode();
        org.kie.workbench.common.stunner.core.graph.content.Bounds relativeBounds = ((View)node.getContent()).getBounds();
        double absoluteX = PARENT_ABSOLUTE_X1 + relativeBounds.getUpperLeft().getX();
        double absoluteY = PARENT_ABSOLUTE_Y1 + relativeBounds.getUpperLeft().getY();
        ((BoundaryEventPropertyWriter)this.propertyWriter).setAbsoluteBounds(node);
        Bounds shapeBounds = ((BoundaryEventPropertyWriter)this.propertyWriter).getShape().getBounds();
        Assert.assertEquals((double)absoluteX, (double)shapeBounds.getX(), (double)0.0);
        Assert.assertEquals((double)absoluteY, (double)shapeBounds.getY(), (double)0.0);
        Assert.assertEquals((double)relativeBounds.getWidth(), (double)shapeBounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)relativeBounds.getHeight(), (double)shapeBounds.getHeight(), (double)0.0);
        this.verifyDockerInfoWasSet(relativeBounds);
    }

    private void verifyDockerInfoWasSet(org.kie.workbench.common.stunner.core.graph.content.Bounds relativeBounds) {
        ((FeatureMap)Mockito.verify((Object)this.featureMap)).add(this.entryCaptor.capture());
        Assert.assertEquals((Object)String.format("drools:dockerinfo=%s^%s|", relativeBounds.getUpperLeft().getX(), relativeBounds.getUpperLeft().getY()), (Object)((FeatureMap.Entry)this.entryCaptor.getValue()).toString());
    }
}

