/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.ArrayList;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.AbstractBasePropertyWriterTest;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.GatewayPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GatewayPropertyWriterTest
extends AbstractBasePropertyWriterTest<GatewayPropertyWriter, Gateway> {
    private static final String SEQUENCE_ID = "SEQUENCE_ID";
    @Mock
    private FeatureMap featureMap;
    @Captor
    private ArgumentCaptor<FeatureMap.Entry> entryCaptor;
    @Mock
    private PropertyWriter anotherPropertyWriter;
    @Mock
    private SequenceFlow sequenceFlow;

    @Override
    protected GatewayPropertyWriter newPropertyWriter(Gateway baseElement, VariableScope variableScope) {
        return new GatewayPropertyWriter(baseElement, variableScope);
    }

    @Override
    protected Gateway mockElement() {
        return this.mockGateway(Gateway.class, "PARENT_ID");
    }

    @Test
    public void testSetDefaultRoute() {
        this.testSetDefaultRoute("defaultRoute", "defaultRoute");
    }

    @Test
    public void testSetDefaultRouteWithPrefix() {
        this.testSetDefaultRoute("prefix : defaultRoute", "defaultRoute");
    }

    @Test
    public void testSetDefaultRouteNull() {
        ((GatewayPropertyWriter)this.propertyWriter).setDefaultRoute(null);
        ((FeatureMap)Mockito.verify((Object)this.featureMap, (VerificationMode)Mockito.never())).add(ArgumentMatchers.any());
    }

    private void testSetDefaultRoute(String defaultRoute, String expectedGatewayId) {
        ((GatewayPropertyWriter)this.propertyWriter).setDefaultRoute(defaultRoute);
        ((FeatureMap)Mockito.verify((Object)this.featureMap)).add(this.entryCaptor.capture());
        Assert.assertEquals((Object)String.format("drools:dg=%s", defaultRoute), (Object)((FeatureMap.Entry)this.entryCaptor.getValue()).toString());
        Assert.assertEquals((Object)expectedGatewayId, (Object)((GatewayPropertyWriter)this.propertyWriter).getDefaultGatewayId());
    }

    @Test
    public void testSetSourceForExclusiveGateway() {
        ExclusiveGateway exclusiveGateway = this.mockGateway(ExclusiveGateway.class, "PARENT_ID");
        this.prepareTestSetSourceOrTarget((Gateway)exclusiveGateway);
        ((GatewayPropertyWriter)this.propertyWriter).setSource((BasePropertyWriter)this.anotherPropertyWriter);
        ((ExclusiveGateway)Mockito.verify((Object)exclusiveGateway)).setDefault(this.sequenceFlow);
    }

    @Test
    public void testSetSourceForInclusiveGateway() {
        InclusiveGateway inclusiveGateway = this.mockGateway(InclusiveGateway.class, "PARENT_ID");
        this.prepareTestSetSourceOrTarget((Gateway)inclusiveGateway);
        ((GatewayPropertyWriter)this.propertyWriter).setSource((BasePropertyWriter)this.anotherPropertyWriter);
        ((InclusiveGateway)Mockito.verify((Object)inclusiveGateway)).setDefault(this.sequenceFlow);
    }

    @Test
    public void testSetTargetForExclusiveGateway() {
        ExclusiveGateway exclusiveGateway = this.mockGateway(ExclusiveGateway.class, "PARENT_ID");
        this.prepareTestSetSourceOrTarget((Gateway)exclusiveGateway);
        ((GatewayPropertyWriter)this.propertyWriter).setTarget((BasePropertyWriter)this.anotherPropertyWriter);
        ((ExclusiveGateway)Mockito.verify((Object)exclusiveGateway)).setDefault(this.sequenceFlow);
    }

    @Test
    public void testSetTargetForInclusiveGateway() {
        InclusiveGateway inclusiveGateway = this.mockGateway(InclusiveGateway.class, "PARENT_ID");
        this.prepareTestSetSourceOrTarget((Gateway)inclusiveGateway);
        ((GatewayPropertyWriter)this.propertyWriter).setTarget((BasePropertyWriter)this.anotherPropertyWriter);
        ((InclusiveGateway)Mockito.verify((Object)inclusiveGateway)).setDefault(this.sequenceFlow);
    }

    private void prepareTestSetSourceOrTarget(Gateway gateway) {
        Mockito.when((Object)this.sequenceFlow.getId()).thenReturn((Object)SEQUENCE_ID);
        Mockito.when((Object)this.anotherPropertyWriter.getElement()).thenReturn((Object)this.sequenceFlow);
        this.propertyWriter = new GatewayPropertyWriter(gateway, this.variableScope);
        ((GatewayPropertyWriter)this.propertyWriter).setDefaultRoute(SEQUENCE_ID);
    }

    @Test
    public void testSetGatewayDirectionWithDivergingNode() {
        Node node = this.mockNode(1, 2);
        ((GatewayPropertyWriter)this.propertyWriter).setGatewayDirection(node);
        ((Gateway)Mockito.verify((Object)this.element)).setGatewayDirection(GatewayDirection.DIVERGING);
    }

    @Test
    public void testSetGatewayDirectionWithConvergingNode() {
        Node node = this.mockNode(2, 1);
        ((GatewayPropertyWriter)this.propertyWriter).setGatewayDirection(node);
        ((Gateway)Mockito.verify((Object)this.element)).setGatewayDirection(GatewayDirection.CONVERGING);
    }

    @Test
    public void testSetGatewayDirectionWithNotConfiguredNode() {
        Node node = this.mockNode(0, 0);
        ((GatewayPropertyWriter)this.propertyWriter).setGatewayDirection(node);
        ((Gateway)Mockito.verify((Object)this.element)).setGatewayDirection(GatewayDirection.UNSPECIFIED);
    }

    @Test
    public void testSetGatewayDirection() {
        GatewayDirection randomDirection = GatewayDirection.CONVERGING;
        ((GatewayPropertyWriter)this.propertyWriter).setGatewayDirection(randomDirection);
        ((Gateway)Mockito.verify((Object)this.element)).setGatewayDirection(randomDirection);
    }

    protected <T extends Gateway> T mockGateway(Class<T> classToMock, String id) {
        Gateway gateway = (Gateway)Mockito.mock(classToMock);
        Mockito.when((Object)gateway.getAnyAttribute()).thenReturn((Object)this.featureMap);
        Mockito.when((Object)gateway.getId()).thenReturn((Object)id);
        return (T)gateway;
    }

    private Node mockNode(int inEdgesSize, int outEdgesSize) {
        Edge edge;
        Node node = (Node)Mockito.mock(Node.class);
        ArrayList<Edge> inEdges = new ArrayList<Edge>();
        Mockito.when((Object)node.getInEdges()).thenReturn(inEdges);
        for (int i = 0; i < inEdgesSize; ++i) {
            edge = (Edge)Mockito.mock(Edge.class);
            Mockito.when((Object)edge.getContent()).thenReturn(Mockito.mock(ViewConnector.class));
            inEdges.add(edge);
        }
        ArrayList<Edge> outEdges = new ArrayList<Edge>();
        Mockito.when((Object)node.getOutEdges()).thenReturn(outEdges);
        for (int i = 0; i < outEdgesSize; ++i) {
            edge = (Edge)Mockito.mock(Edge.class);
            Mockito.when((Object)edge.getContent()).thenReturn(Mockito.mock(ViewConnector.class));
            outEdges.add(edge);
        }
        return node;
    }
}

