/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks;

import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.UserTask;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.UserTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks.BaseTaskConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks.BaseTaskConverterTest;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks.TaskConverter;
import org.kie.workbench.common.stunner.bpmn.definition.NoneTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.assignee.Actors;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskConverterTest
extends BaseTaskConverterTest {
    private static final String NAME = "NAME";
    private static final String TASK_NAME = "TASK_NAME";
    private static final Actors ACTORS = new Actors();
    private static final String GROUP_ID = "GROUP_ID";
    private static final String DOCUMENTATION = "DOCUMENTATION";
    private static final Boolean IS_ASYNC = Boolean.TRUE;
    private static final Boolean SKIPPABLE = Boolean.TRUE;
    private static final String PRIORITY = "PRIORITY";
    private static final String SUBJECT = "SUBJECT";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String CREATED_BY = "CREATED_BY";
    private static final Boolean IS_AUTOSTART = Boolean.TRUE;
    private static final Boolean SEQUENTIAL = Boolean.TRUE;
    private static final String COLLECTION_INPUT = "COLLECTION_INPUT";
    private static final String COLLECTION_OUTPUT = "COLLECTION_OUTPUT";
    private static final String DATA_INPUT = "DATA_INPUT";
    private static final String DATA_OUTPUT = "DATA_OUTPUT";
    private static final String COMPLETION_CONDITION = "COMPLETION_CONDITION";
    private static final ScriptTypeListValue ON_ENTRY_ACTION = new ScriptTypeListValue();
    private static final ScriptTypeListValue ON_EXIT_ACTION = new ScriptTypeListValue();
    private static final String CONTENT = "CONTENT";
    private static final String SLA_DUE_DATE = "SLA_DUE_DATE";
    private static final Bounds BOUNDS = Bounds.create();
    private static final SimulationSet SIMULATION_SET = new SimulationSet();
    private static final RectangleDimensionsSet RECTANGLE_DIMENSIONS_SET = new RectangleDimensionsSet();
    private static final FontSet FONT_SET = new FontSet();
    private static final BackgroundSet BACKGROUND_SET = new BackgroundSet();
    private static final AssignmentsInfo ASSIGNMENTS_INFO = new AssignmentsInfo();
    @Mock
    private UserTask userTask;
    @Mock
    private Node<View<org.kie.workbench.common.stunner.bpmn.definition.UserTask>, Edge> userTaskNode;
    @Mock
    private View<org.kie.workbench.common.stunner.bpmn.definition.UserTask> userTaskContent;
    private org.kie.workbench.common.stunner.bpmn.definition.UserTask userTaskDefinition;
    @Mock
    private UserTaskPropertyReader userTaskPropertyReader;

    @Override
    public void setUp() {
        super.setUp();
        this.userTaskDefinition = new org.kie.workbench.common.stunner.bpmn.definition.UserTask();
        Mockito.when((Object)this.factoryManager.newNode((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(org.kie.workbench.common.stunner.bpmn.definition.UserTask.class))).thenReturn(this.userTaskNode);
        Mockito.when((Object)this.userTaskNode.getContent()).thenReturn(this.userTaskContent);
        Mockito.when((Object)((View)this.userTaskNode.getContent()).getDefinition()).thenReturn((Object)this.userTaskDefinition);
        Mockito.when((Object)this.propertyReaderFactory.of(this.userTask)).thenReturn((Object)this.userTaskPropertyReader);
        Mockito.when((Object)this.userTaskPropertyReader.getName()).thenReturn((Object)NAME);
        Mockito.when((Object)this.userTaskPropertyReader.getDocumentation()).thenReturn((Object)DOCUMENTATION);
        Mockito.when((Object)this.userTaskPropertyReader.getSimulationSet()).thenReturn((Object)SIMULATION_SET);
        Mockito.when((Object)this.userTaskPropertyReader.getBounds()).thenReturn((Object)BOUNDS);
        Mockito.when((Object)this.userTaskPropertyReader.getRectangleDimensionsSet()).thenReturn((Object)RECTANGLE_DIMENSIONS_SET);
        Mockito.when((Object)this.userTaskPropertyReader.getBackgroundSet()).thenReturn((Object)BACKGROUND_SET);
        Mockito.when((Object)this.userTaskPropertyReader.getFontSet()).thenReturn((Object)FONT_SET);
        Mockito.when((Object)this.userTaskPropertyReader.getTaskName()).thenReturn((Object)TASK_NAME);
        Mockito.when((Object)this.userTaskPropertyReader.getActors()).thenReturn((Object)ACTORS);
        Mockito.when((Object)this.userTaskPropertyReader.getGroupid()).thenReturn((Object)GROUP_ID);
        Mockito.when((Object)this.userTaskPropertyReader.getAssignmentsInfo()).thenReturn((Object)ASSIGNMENTS_INFO);
        Mockito.when((Object)this.userTaskPropertyReader.isAsync()).thenReturn((Object)IS_ASYNC);
        Mockito.when((Object)this.userTaskPropertyReader.isSkippable()).thenReturn((Object)SKIPPABLE);
        Mockito.when((Object)this.userTaskPropertyReader.getPriority()).thenReturn((Object)PRIORITY);
        Mockito.when((Object)this.userTaskPropertyReader.getSubject()).thenReturn((Object)SUBJECT);
        Mockito.when((Object)this.userTaskPropertyReader.getDescription()).thenReturn((Object)DESCRIPTION);
        Mockito.when((Object)this.userTaskPropertyReader.getCreatedBy()).thenReturn((Object)CREATED_BY);
        Mockito.when((Object)this.userTaskPropertyReader.isAdHocAutostart()).thenReturn((Object)IS_AUTOSTART);
        Mockito.when((Object)this.userTaskPropertyReader.isSequential()).thenReturn((Object)SEQUENTIAL);
        Mockito.when((Object)this.userTaskPropertyReader.getCollectionInput()).thenReturn((Object)COLLECTION_INPUT);
        Mockito.when((Object)this.userTaskPropertyReader.getCollectionOutput()).thenReturn((Object)COLLECTION_OUTPUT);
        Mockito.when((Object)this.userTaskPropertyReader.getDataInput()).thenReturn((Object)DATA_INPUT);
        Mockito.when((Object)this.userTaskPropertyReader.getDataOutput()).thenReturn((Object)DATA_OUTPUT);
        Mockito.when((Object)this.userTaskPropertyReader.getCompletionCondition()).thenReturn((Object)COMPLETION_CONDITION);
        Mockito.when((Object)this.userTaskPropertyReader.getOnEntryAction()).thenReturn((Object)ON_ENTRY_ACTION);
        Mockito.when((Object)this.userTaskPropertyReader.getOnExitAction()).thenReturn((Object)ON_EXIT_ACTION);
        Mockito.when((Object)this.userTaskPropertyReader.getContent()).thenReturn((Object)CONTENT);
        Mockito.when((Object)this.userTaskPropertyReader.getSLADueDate()).thenReturn((Object)SLA_DUE_DATE);
    }

    @Override
    protected BaseTaskConverter createTaskConverter() {
        return new TaskConverter(this.factoryManager, this.propertyReaderFactory, MarshallingRequest.Mode.AUTO);
    }

    @Test
    public void testConvertUserTaskMI() {
        Mockito.when((Object)this.userTaskPropertyReader.isMultipleInstance()).thenReturn((Object)true);
        BpmnNode node = (BpmnNode)this.tested.convert((Task)this.userTask).value();
        org.kie.workbench.common.stunner.bpmn.definition.UserTask result = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)((View)node.value().getContent()).getDefinition();
        this.assertCommonValues(result);
        Assert.assertTrue((boolean)result.getExecutionSet().getIsMultipleInstance().getValue());
        Assert.assertEquals((Object)SEQUENTIAL, (Object)result.getExecutionSet().getMultipleInstanceExecutionMode().isSequential());
        Assert.assertEquals((Object)COLLECTION_INPUT, (Object)result.getExecutionSet().getMultipleInstanceCollectionInput().getValue());
        Assert.assertEquals((Object)COLLECTION_OUTPUT, (Object)result.getExecutionSet().getMultipleInstanceCollectionOutput().getValue());
        Assert.assertEquals((Object)DATA_INPUT, (Object)result.getExecutionSet().getMultipleInstanceDataInput().getValue());
        Assert.assertEquals((Object)DATA_OUTPUT, (Object)result.getExecutionSet().getMultipleInstanceDataOutput().getValue());
        Assert.assertEquals((Object)COMPLETION_CONDITION, (Object)result.getExecutionSet().getMultipleInstanceCompletionCondition().getValue());
    }

    @Test
    public void testConvertUserTaskNonMI() {
        Mockito.when((Object)this.userTaskPropertyReader.isMultipleInstance()).thenReturn((Object)false);
        Mockito.when((Object)this.userTaskPropertyReader.isSequential()).thenReturn((Object)false);
        Mockito.when((Object)this.userTaskPropertyReader.getCollectionInput()).thenReturn(null);
        Mockito.when((Object)this.userTaskPropertyReader.getDataInput()).thenReturn(null);
        Mockito.when((Object)this.userTaskPropertyReader.getCollectionOutput()).thenReturn(null);
        Mockito.when((Object)this.userTaskPropertyReader.getDataOutput()).thenReturn(null);
        Mockito.when((Object)this.userTaskPropertyReader.getCompletionCondition()).thenReturn(null);
        BpmnNode node = (BpmnNode)this.tested.convert((Task)this.userTask).value();
        org.kie.workbench.common.stunner.bpmn.definition.UserTask result = (org.kie.workbench.common.stunner.bpmn.definition.UserTask)((View)node.value().getContent()).getDefinition();
        this.assertCommonValues(result);
        Assert.assertFalse((boolean)result.getExecutionSet().getIsMultipleInstance().getValue());
        Assert.assertFalse((boolean)result.getExecutionSet().getMultipleInstanceExecutionMode().isSequential());
        Assert.assertNull((Object)result.getExecutionSet().getMultipleInstanceCollectionInput().getValue());
        Assert.assertNull((Object)result.getExecutionSet().getMultipleInstanceCollectionOutput().getValue());
        Assert.assertNull((Object)result.getExecutionSet().getMultipleInstanceDataInput().getValue());
        Assert.assertNull((Object)result.getExecutionSet().getMultipleInstanceDataOutput().getValue());
        Assert.assertNull((Object)result.getExecutionSet().getMultipleInstanceCompletionCondition().getValue());
    }

    private void assertCommonValues(org.kie.workbench.common.stunner.bpmn.definition.UserTask result) {
        Assert.assertEquals((Object)NAME, (Object)result.getGeneral().getName().getValue());
        Assert.assertEquals((Object)DOCUMENTATION, (Object)result.getGeneral().getDocumentation().getValue());
        Assert.assertEquals((Object)SIMULATION_SET, (Object)result.getSimulationSet());
        ((View)Mockito.verify(this.userTaskContent)).setBounds(BOUNDS);
        Assert.assertEquals((Object)ACTORS, (Object)result.getExecutionSet().getActors());
        Assert.assertEquals((Object)GROUP_ID, (Object)result.getExecutionSet().getGroupid().getValue());
        Assert.assertEquals((Object)ASSIGNMENTS_INFO, (Object)result.getExecutionSet().getAssignmentsinfo());
        Assert.assertEquals((Object)IS_ASYNC, (Object)result.getExecutionSet().getIsAsync().getValue());
        Assert.assertEquals((Object)SKIPPABLE, (Object)result.getExecutionSet().getSkippable().getValue());
        Assert.assertEquals((Object)PRIORITY, (Object)result.getExecutionSet().getPriority().getValue());
        Assert.assertEquals((Object)SUBJECT, (Object)result.getExecutionSet().getSubject().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)result.getExecutionSet().getDescription().getValue());
        Assert.assertEquals((Object)CREATED_BY, (Object)result.getExecutionSet().getCreatedBy().getValue());
        Assert.assertEquals((Object)IS_AUTOSTART, (Object)result.getExecutionSet().getAdHocAutostart().getValue());
        Assert.assertEquals((Object)ON_ENTRY_ACTION, (Object)result.getExecutionSet().getOnEntryAction().getValue());
        Assert.assertEquals((Object)ON_EXIT_ACTION, (Object)result.getExecutionSet().getOnExitAction().getValue());
        Assert.assertEquals((Object)CONTENT, (Object)result.getExecutionSet().getContent().getValue());
        Assert.assertEquals((Object)SLA_DUE_DATE, (Object)result.getExecutionSet().getSlaDueDate().getValue());
    }

    @Test
    public void testConvertManualTask() {
        this.testConvertToDefaultTask((Task)Bpmn2Factory.eINSTANCE.createManualTask());
    }

    @Test
    public void testConvertReceiveTask() {
        this.testConvertToDefaultTask((Task)Bpmn2Factory.eINSTANCE.createReceiveTask());
    }

    @Test
    public void testConvertSendTask() {
        this.testConvertToDefaultTask((Task)Bpmn2Factory.eINSTANCE.createSendTask());
    }

    @Test
    public void testConvertNoneTask() {
        this.testConvertToDefaultTask(Bpmn2Factory.eINSTANCE.createTask());
    }

    private void testConvertToDefaultTask(Task task) {
        TaskPropertyReader reader = (TaskPropertyReader)Mockito.mock(TaskPropertyReader.class);
        Mockito.when((Object)this.propertyReaderFactory.of(task)).thenReturn((Object)reader);
        Node taskNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.factoryManager.newNode((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(NoneTask.class))).thenReturn((Object)taskNode);
        View taskContent = (View)Mockito.mock(View.class);
        Mockito.when((Object)taskNode.getContent()).thenReturn((Object)taskContent);
        NoneTask taskDef = (NoneTask)Mockito.mock(NoneTask.class);
        Mockito.when((Object)taskContent.getDefinition()).thenReturn((Object)taskDef);
        Result result = this.tested.convert(task);
        ((TypedFactoryManager)Mockito.verify((Object)this.factoryManager)).newNode((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(NoneTask.class));
        Assert.assertTrue((boolean)(((View)((BpmnNode)result.value()).value().getContent()).getDefinition() instanceof NoneTask));
    }
}

