/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.junit.Assert;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.BPMNTestDefinitionFactory;
import org.kie.workbench.common.stunner.bpmn.WorkItemDefinitionMockRegistry;
import org.kie.workbench.common.stunner.bpmn.backend.BPMNDirectDiagramMarshaller;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.DataTypeCacheServer;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.Unmarshalling;
import org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask;
import org.kie.workbench.common.stunner.bpmn.definition.NoneTask;
import org.kie.workbench.common.stunner.bpmn.definition.ScriptTask;
import org.kie.workbench.common.stunner.bpmn.definition.UserTask;
import org.kie.workbench.common.stunner.bpmn.definition.morph.BaseTaskMorphPropertyDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.service.WorkItemDefinitionLookupService;
import org.kie.workbench.common.stunner.core.backend.StunnerTestingGraphBackendAPI;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.bind.BackendBindableMorphAdapter;
import org.kie.workbench.common.stunner.core.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.definition.clone.CloneManager;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.definition.TypeDefinitionFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public abstract class BPMNDiagramMarshallerBaseTest {
    @Mock
    private CloneManager cloneManager;
    protected StunnerTestingGraphBackendAPI api;
    protected WorkItemDefinitionMockRegistry workItemDefinitionMockRegistry;
    protected BPMNDirectDiagramMarshaller marshaller;
    @Mock
    private DataTypeCacheServer dataTypeCacheServer;

    protected void init() {
        MockitoAnnotations.initMocks((Object)this);
        this.cloneManager = (CloneManager)Mockito.mock(CloneManager.class);
        try {
            this.api = StunnerTestingGraphBackendAPI.build(BPMNDefinitionSet.class, (TypeDefinitionFactory)new BPMNTestDefinitionFactory());
        }
        catch (Exception e) {
            Assert.fail((String)("Cannot instantiate DefinitionSet [message=" + e.getMessage() + "]"));
        }
        BackendBindableMorphAdapter morphAdapter = new BackendBindableMorphAdapter(this.api.getDefinitionUtils(), this.api.getFactoryManager(), this.cloneManager, Collections.singletonList(new BaseTaskMorphPropertyDefinition()));
        ((AdapterRegistry)Mockito.doReturn((Object)morphAdapter).when((Object)this.api.getAdapterRegistry())).getMorphAdapter((Class)ArgumentMatchers.eq(UserTask.class));
        ((AdapterRegistry)Mockito.doReturn((Object)morphAdapter).when((Object)this.api.getAdapterRegistry())).getMorphAdapter((Class)ArgumentMatchers.eq(NoneTask.class));
        ((AdapterRegistry)Mockito.doReturn((Object)morphAdapter).when((Object)this.api.getAdapterRegistry())).getMorphAdapter((Class)ArgumentMatchers.eq(ScriptTask.class));
        ((AdapterRegistry)Mockito.doReturn((Object)morphAdapter).when((Object)this.api.getAdapterRegistry())).getMorphAdapter((Class)ArgumentMatchers.eq(BusinessRuleTask.class));
        this.workItemDefinitionMockRegistry = new WorkItemDefinitionMockRegistry();
        WorkItemDefinitionLookupService widService = (WorkItemDefinitionLookupService)Mockito.mock(WorkItemDefinitionLookupService.class);
        Mockito.when((Object)widService.execute(ArgumentMatchers.any(Metadata.class))).thenReturn((Object)this.workItemDefinitionMockRegistry.items());
        this.marshaller = new BPMNDirectDiagramMarshaller(new XMLEncoderDiagramMetadataMarshaller(), this.api.getDefinitionManager(), this.api.getRuleManager(), widService, this.api.getFactoryManager(), this.api.commandFactory, this.api.commandManager, this.dataTypeCacheServer);
    }

    protected void assertDiagram(Diagram<Graph, Metadata> diagram, int nodesSize) {
        Assert.assertEquals((long)nodesSize, (long)this.getNodes(diagram).size());
    }

    protected List<Node> getNodes(Diagram<Graph, Metadata> diagram) {
        Graph graph = diagram.getGraph();
        Assert.assertNotNull((Object)graph);
        Iterator nodesIterable = graph.nodes().iterator();
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodesIterable.forEachRemaining(nodes::add);
        return nodes;
    }

    protected Diagram<Graph, Metadata> unmarshall(DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>> marshaller, String fileName) throws Exception {
        return Unmarshalling.unmarshall(marshaller, fileName);
    }

    protected Diagram<Graph, Metadata> unmarshall(DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>> marshaller, InputStream is) throws Exception {
        return Unmarshalling.unmarshall(marshaller, is);
    }

    protected Definitions convertToDefinitions(Diagram<Graph, Metadata> d) {
        return new DefinitionsConverter(d.getGraph()).toDefinitions();
    }

    protected InputStream getStream(String data) {
        return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
    }
}

