/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.EndEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.EndSignalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.ScopedSignalEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class EndSignalEventTest
extends EndEventTest<EndSignalEvent> {
    private static final String BPMN_END_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endSignalEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_CC780D57-DE0C-4D87-B574-B853E1080322";
    private static final String FILLED_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID = "_6EC8E2EC-4E6F-4CED-AF70-86DB72F6B62E";
    private static final String FILLED_TOP_LEVEL_EVENT_PROJECT_SCOPE_ID = "_0649DF6B-2567-4203-9B9F-51F4CE4A2175";
    private static final String FILLED_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID = "_CC495DF0-6CA7-4F21-ACF5-DDC28F30A302";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_81EA04C5-0F79-4293-B78F-B93598A4152C";
    private static final String FILLED_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID = "_169E8E1F-A3C4-4B8D-9BEC-F43435BFC882";
    private static final String FILLED_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID = "_B0A8166F-3893-4CAB-A232-8E96C9B28204";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID = "_D9D2B905-247D-454B-93F6-9B9D0E88767A";
    private static final String EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_ECBC3872-2949-4715-9649-0918057B3B9D";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID = "_94469674-2F60-451C-AFBB-8701E53DA085";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_PROJECT_SCOPE_ID = "_6E805887-A67D-4CA8-A96F-1038A8154182";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID = "_3D27EE98-B57D-453F-BC33-A2D1E15B3ACB";
    private static final String EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_A7D0EDD8-34CA-4537-82A4-F156DDD6C30C";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID = "_2D60DFA5-595A-4125-9249-7474FBCBB582";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID = "_553653BE-F237-4D43-8601-351E7B062956";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID = "_EF073D03-2A7E-488C-9A1A-B4F30AD88FA2";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 26;
    private static final String EVENT_SIGNAL_SCOPE_DEFAULT = "";
    private static final String EVENT_SIGNAL_SCOPE_PROCESS_INSTANCE = "processInstance";
    private static final String EVENT_SIGNAL_SCOPE_PROJECT = "project";
    private static final String EVENT_SIGNAL_SCOPE_EXTERNAL = "external";

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME_PROCESS_INSTANCE_SCOPE = "signal name01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROCESS_INSTANCE_SCOPE = "signal01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROCESS_INSTANCE_SCOPE = "signal01";
        String EVENT_DATA_INPUT_PROCESS_INSTANCE_SCOPE = "signal01:String||||[din]processGlobalVar->signal01";
        String EVENT_NAME_PROJECT_SCOPE = "signal name02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROJECT_SCOPE = "signal02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROJECT_SCOPE = "signal02";
        String EVENT_DATA_INPUT_PROJECT_SCOPE = "signal02:String||||[din]processGlobalVar->signal02";
        String EVENT_NAME_EXTERNAL_SCOPE = "signal name03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_EXTERNAL_SCOPE = "signal03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_EXTERNAL_SCOPE = "signal03";
        String EVENT_DATA_INPUT_EXTERNAL_SCOPE = "signal03:String||||[din]processGlobalVar->signal03";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 26);
        EndSignalEvent filledTopEventProcessInstance = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID, false);
        this.assertGeneralSet(filledTopEventProcessInstance.getGeneral(), "signal name01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventProcessInstance.getExecutionSet(), "signal01", EVENT_SIGNAL_SCOPE_PROCESS_INSTANCE);
        this.assertDataIOSet(filledTopEventProcessInstance.getDataIOSet(), "signal01:String||||[din]processGlobalVar->signal01");
        EndSignalEvent filledTopEventProject = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_TOP_LEVEL_EVENT_PROJECT_SCOPE_ID, false);
        this.assertGeneralSet(filledTopEventProject.getGeneral(), "signal name02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventProject.getExecutionSet(), "signal02", EVENT_SIGNAL_SCOPE_PROJECT);
        this.assertDataIOSet(filledTopEventProject.getDataIOSet(), "signal02:String||||[din]processGlobalVar->signal02");
        EndSignalEvent filledTopEventExternal = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID, false);
        this.assertGeneralSet(filledTopEventExternal.getGeneral(), "signal name03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventExternal.getExecutionSet(), "signal03", EVENT_SIGNAL_SCOPE_EXTERNAL);
        this.assertDataIOSet(filledTopEventExternal.getDataIOSet(), "signal03:String||||[din]processGlobalVar->signal03");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 26);
        EndSignalEvent emptyTopEvent = (EndSignalEvent)this.getEndNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertSignalEventExecutionSet(emptyTopEvent.getExecutionSet(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), EVENT_SIGNAL_SCOPE_DEFAULT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME_PROCESS_INSTANCE_SCOPE = "signal name07 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROCESS_INSTANCE_SCOPE = "signal07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROCESS_INSTANCE_SCOPE = "signal07";
        String EVENT_DATA_INPUT_PROCESS_INSTANCE_SCOPE = "signal07:String||||[din]processGlobalVar->signal07";
        String EVENT_NAME_PROJECT_SCOPE = "signal name08 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROJECT_SCOPE = "signal08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROJECT_SCOPE = "signal08";
        String EVENT_DATA_INPUT_PROJECT_SCOPE = "signal08:String||||[din]processGlobalVar->signal08";
        String EVENT_NAME_EXTERNAL_SCOPE = "signal name09 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_EXTERNAL_SCOPE = "signal09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_EXTERNAL_SCOPE = "signal09";
        String EVENT_DATA_INPUT_EXTERNAL_SCOPE = "signal09:String||||[din]processGlobalVar->signal09";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 26);
        EndSignalEvent filledSubprocessEventProcessInstance = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID, false);
        this.assertGeneralSet(filledSubprocessEventProcessInstance.getGeneral(), "signal name07 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventProcessInstance.getExecutionSet(), "signal07", EVENT_SIGNAL_SCOPE_PROCESS_INSTANCE);
        this.assertDataIOSet(filledSubprocessEventProcessInstance.getDataIOSet(), "signal07:String||||[din]processGlobalVar->signal07");
        EndSignalEvent filledSubprocessEventProject = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID, false);
        this.assertGeneralSet(filledSubprocessEventProject.getGeneral(), "signal name08 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventProject.getExecutionSet(), "signal08", EVENT_SIGNAL_SCOPE_PROJECT);
        this.assertDataIOSet(filledSubprocessEventProject.getDataIOSet(), "signal08:String||||[din]processGlobalVar->signal08");
        EndSignalEvent filledSubprocessEventExternal = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID, false);
        this.assertGeneralSet(filledSubprocessEventExternal.getGeneral(), "signal name09 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventExternal.getExecutionSet(), "signal09", EVENT_SIGNAL_SCOPE_EXTERNAL);
        this.assertDataIOSet(filledSubprocessEventExternal.getDataIOSet(), "signal09:String||||[din]processGlobalVar->signal09");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 26);
        EndSignalEvent emptySubprocessEvent = (EndSignalEvent)this.getEndNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertSignalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), EVENT_SIGNAL_SCOPE_DEFAULT);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME_PROCESS_INSTANCE_SCOPE = "signal name04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROCESS_INSTANCE_SCOPE = "signal04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROCESS_INSTANCE_SCOPE = "signal04";
        String EVENT_DATA_INPUT_PROCESS_INSTANCE_SCOPE = "signal04:String||||[din]processGlobalVar->signal04";
        String EVENT_NAME_PROJECT_SCOPE = "signal name05 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROJECT_SCOPE = "signal05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROJECT_SCOPE = "signal05";
        String EVENT_DATA_INPUT_PROJECT_SCOPE = "signal05:String||||[din]processGlobalVar->signal05";
        String EVENT_NAME_EXTERNAL_SCOPE = "signal name06 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_EXTERNAL_SCOPE = "signal06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_EXTERNAL_SCOPE = "signal06";
        String EVENT_DATA_INPUT_EXTERNAL_SCOPE = "signal06:String||||[din]processGlobalVar->signal06";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 26);
        EndSignalEvent filledTopEventProcessInstance = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID, true);
        this.assertGeneralSet(filledTopEventProcessInstance.getGeneral(), "signal name04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventProcessInstance.getExecutionSet(), "signal04", EVENT_SIGNAL_SCOPE_PROCESS_INSTANCE);
        this.assertDataIOSet(filledTopEventProcessInstance.getDataIOSet(), "signal04:String||||[din]processGlobalVar->signal04");
        EndSignalEvent filledTopEventProject = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_PROJECT_SCOPE_ID, true);
        this.assertGeneralSet(filledTopEventProject.getGeneral(), "signal name05 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventProject.getExecutionSet(), "signal05", EVENT_SIGNAL_SCOPE_PROJECT);
        this.assertDataIOSet(filledTopEventProject.getDataIOSet(), "signal05:String||||[din]processGlobalVar->signal05");
        EndSignalEvent filledTopEventExternal = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID, true);
        this.assertGeneralSet(filledTopEventExternal.getGeneral(), "signal name06 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEventExternal.getExecutionSet(), "signal06", EVENT_SIGNAL_SCOPE_EXTERNAL);
        this.assertDataIOSet(filledTopEventExternal.getDataIOSet(), "signal06:String||||[din]processGlobalVar->signal06");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 26);
        EndSignalEvent emptyEvent = (EndSignalEvent)this.getEndNodeById(diagram, EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertSignalEventExecutionSet(emptyEvent.getExecutionSet(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertDataIOSet(emptyEvent.getDataIOSet(), EVENT_SIGNAL_SCOPE_DEFAULT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 26);
        EndSignalEvent emptySubprocessEvent = (EndSignalEvent)this.getEndNodeById(diagram, EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertSignalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), EVENT_SIGNAL_SCOPE_DEFAULT, EVENT_SIGNAL_SCOPE_DEFAULT);
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), EVENT_SIGNAL_SCOPE_DEFAULT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME_PROCESS_INSTANCE_SCOPE = "signal name10 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROCESS_INSTANCE_SCOPE = "signal10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROCESS_INSTANCE_SCOPE = "signal10";
        String EVENT_DATA_INPUT_PROCESS_INSTANCE_SCOPE = "signal10:String||||[din]processGlobalVar->signal10";
        String EVENT_NAME_PROJECT_SCOPE = "signal name11 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_PROJECT_SCOPE = "signal11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_PROJECT_SCOPE = "signal11";
        String EVENT_DATA_INPUT_PROJECT_SCOPE = "signal11:String||||[din]processGlobalVar->signal11";
        String EVENT_NAME_EXTERNAL_SCOPE = "signal name12 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION_EXTERNAL_SCOPE = "signal12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF_EXTERNAL_SCOPE = "signal12";
        String EVENT_DATA_INPUT_EXTERNAL_SCOPE = "signal12:String||||[din]processGlobalVar->signal12";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 26);
        EndSignalEvent filledSubprocessEventProcessInstance = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID, true);
        this.assertGeneralSet(filledSubprocessEventProcessInstance.getGeneral(), "signal name10 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventProcessInstance.getExecutionSet(), "signal10", EVENT_SIGNAL_SCOPE_PROCESS_INSTANCE);
        this.assertDataIOSet(filledSubprocessEventProcessInstance.getDataIOSet(), "signal10:String||||[din]processGlobalVar->signal10");
        EndSignalEvent filledSubprocessEventProject = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID, true);
        this.assertGeneralSet(filledSubprocessEventProject.getGeneral(), "signal name11 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventProject.getExecutionSet(), "signal11", EVENT_SIGNAL_SCOPE_PROJECT);
        this.assertDataIOSet(filledSubprocessEventProject.getDataIOSet(), "signal11:String||||[din]processGlobalVar->signal11");
        EndSignalEvent filledSubprocessEventExternal = (EndSignalEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID, true);
        this.assertGeneralSet(filledSubprocessEventExternal.getGeneral(), "signal name12 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEventExternal.getExecutionSet(), "signal12", EVENT_SIGNAL_SCOPE_EXTERNAL);
        this.assertDataIOSet(filledSubprocessEventExternal.getDataIOSet(), "signal12:String||||[din]processGlobalVar->signal12");
    }

    @Override
    @Test
    public void testMarshallTopLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID, false);
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_PROJECT_SCOPE_ID, false);
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID, false);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID, false);
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID, false);
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID, false);
    }

    @Override
    @Test
    public void testMarshallTopLevelEventWithIncomeFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_WITH_INCOME_TOP_LEVEL_EVENT_PROCESS_INSTANCE_SCOPE_ID, true);
        this.checkEventMarshalling(FILLED_WITH_INCOME_TOP_LEVEL_PROJECT_SCOPE_ID, true);
        this.checkEventMarshalling(FILLED_WITH_INCOME_TOP_LEVEL_EVENT_EXTERNAL_SCOPE_ID, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception {
        this.checkEventMarshalling(FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROCESS_INSTANCE_SCOPE_ID, true);
        this.checkEventMarshalling(FILLED_WITH_INCOME_SUBPROCESS_LEVEL_PROJECT_SCOPE_ID, true);
        this.checkEventMarshalling(FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_EXTERNAL_SCOPE_ID, true);
    }

    @Override
    String getBpmnEndEventFilePath() {
        return BPMN_END_EVENT_FILE_PATH;
    }

    @Override
    Class<EndSignalEvent> getEndEventType() {
        return EndSignalEvent.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return null;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithIncomeId() {
        return null;
    }

    @Override
    String getEmptyTopLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithIncomeId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertSignalEventExecutionSet(ScopedSignalEventExecutionSet executionSet, String signalReference, String signalScope) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getSignalRef());
        Assert.assertNotNull((Object)executionSet.getSignalScope());
        Assert.assertEquals((Object)signalReference, (Object)executionSet.getSignalRef().getValue());
        Assert.assertEquals((Object)signalScope, (Object)executionSet.getSignalScope().getValue());
    }
}

