/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsConverter;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses.SubProcessTest;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EmbeddedSubprocessExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class EmbeddedSubProcessTest
extends SubProcessTest<EmbeddedSubprocess> {
    private static final String BPMN_SUB_PROCESS_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/embeddedSubProcesses.bpmn";
    private static final String TOP_LEVEL_EMPTY_SUBPROCESS_ID = "_E9D3FBF1-55DE-4C93-8CFE-67FD311BB452";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID = "_8050BE36-E9A9-4461-BE33-6813B891D1D9";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID = "_395EFE1F-4FED-4114-BF8C-C6094A556B65";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID = "_0C0C20E4-A384-4F9E-BDCE-D13CA2C54506";
    private static final String SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID = "_7C50F29B-02A6-4839-B1B7-E41F94A8ADAE";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID = "_76188540-34C4-48C3-979D-9CA8D89ECFE1";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID = "_556F8833-ACC8-4CAF-ABA8-2A34A42F3A20";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID = "_8305C048-5790-4717-A219-66F39209C652";
    private static final String TOP_LEVEL_SUBPROCESS_WITH_EDGES = "_B4FFD902-D756-4C37-960D-74487547A934";
    private static final String SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES = "_DE818F69-E02C-471E-8F0B-27101308541B";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 23;
    private static final String SUBPROCESS_SCRIPT_JAVA_LANGUAGE = "java";
    private static final String SUBPROCESS_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SUBPROCESS_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE = "javascript";
    private static final String SUBPROCESS_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action\");\nprint(\"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");\nprint(\"somevalue\" + \"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");";
    private static final String SUBPROCESS_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action\");\nprint(\"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");\nprint(\"somevalue\" + \"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");";
    private static final String SUBPROCESS_SCRIPT_MVEL_LANGUAGE = "mvel";
    private static final String SUBPROCESS_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SUBPROCESS_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SLA_DUE_DATE = "12/25/1983";

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyPropertiesSubProcess() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        EmbeddedSubprocess topLevelSubProcess = (EmbeddedSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_EMPTY_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcess.getGeneral(), "", "");
        this.assertEmbeddedSubprocessExecutionSet(topLevelSubProcess.getExecutionSet(), false, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "");
        this.assertSubProcessProcessData(topLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelFilledPropertiesSubProcess() {
        String SUB_PROCESS_NAME_JAVA = "Embedded process01 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVA = "Embedded process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_JAVASCRIPT = "Embedded process02 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVASCRIPT = "Embedded process02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_MVEL = "Embedded process03 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_MVEL = "Embedded process03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_VARIABLES_JAVA = "subVar01:String:[]";
        String SUB_PROCESS_VARIABLES_JAVASCRIPT = "subVar02:String:[]";
        String SUB_PROCESS_VARIABLES_MVEL = "subVar03:String:[]";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        EmbeddedSubprocess topLevelSubProcessJava = (EmbeddedSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessJava.getGeneral(), "Embedded process01 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Embedded process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEmbeddedSubprocessExecutionSet(topLevelSubProcessJava.getExecutionSet(), true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(topLevelSubProcessJava.getProcessData(), "subVar01:String:[]");
        EmbeddedSubprocess topLevelSubProcessJavascript = (EmbeddedSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessJavascript.getGeneral(), "Embedded process02 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Embedded process02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEmbeddedSubprocessExecutionSet(topLevelSubProcessJavascript.getExecutionSet(), true, SUBPROCESS_ON_ENTRY_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, SUBPROCESS_ON_EXIT_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(topLevelSubProcessJavascript.getProcessData(), "subVar02:String:[]");
        EmbeddedSubprocess topLevelSubProcessMVEL = (EmbeddedSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessMVEL.getGeneral(), "Embedded process03 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Embedded process03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEmbeddedSubprocessExecutionSet(topLevelSubProcessMVEL.getExecutionSet(), true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_MVEL_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(topLevelSubProcessMVEL.getProcessData(), "subVar03:String:[]");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelSubProcessWithEdges() {
        String SUB_PROCESS_NAME = "Sub-process07";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        EmbeddedSubprocess topLevelSubProcess = (EmbeddedSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_SUBPROCESS_WITH_EDGES, 2, 4);
        this.assertGeneralSet(topLevelSubProcess.getGeneral(), "Sub-process07", "");
        this.assertEmbeddedSubprocessExecutionSet(topLevelSubProcess.getExecutionSet(), false, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "");
        this.assertSubProcessProcessData(topLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelEmptyPropertiesSubProcess() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        EmbeddedSubprocess subProcessLevelSubProcess = (EmbeddedSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcess.getGeneral(), "", "");
        this.assertEmbeddedSubprocessExecutionSet(subProcessLevelSubProcess.getExecutionSet(), false, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "");
        this.assertSubProcessProcessData(subProcessLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelFilledPropertiesSubProcess() {
        String SUB_PROCESS_NAME_JAVA = "Embedded process04 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVA = "Embedded process04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_JAVASCRIPT = "Embedded process05 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVASCRIPT = "Embedded process05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_MVEL = "Embedded process06 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_MVEL = "Embedded process06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_VARIABLES_JAVA = "subVar04:String:[]";
        String SUB_PROCESS_VARIABLES_JAVASCRIPT = "subVar05:String:[]";
        String SUB_PROCESS_VARIABLES_MVEL = "subVar06:String:[]";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        EmbeddedSubprocess subProcessLevelSubProcessJava = (EmbeddedSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessJava.getGeneral(), "Embedded process04 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Embedded process04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEmbeddedSubprocessExecutionSet(subProcessLevelSubProcessJava.getExecutionSet(), true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(subProcessLevelSubProcessJava.getProcessData(), "subVar04:String:[]");
        EmbeddedSubprocess subProcessLevelSubProcessJavascript = (EmbeddedSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessJavascript.getGeneral(), "Embedded process05 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Embedded process05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEmbeddedSubprocessExecutionSet(subProcessLevelSubProcessJavascript.getExecutionSet(), true, SUBPROCESS_ON_ENTRY_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, SUBPROCESS_ON_EXIT_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(subProcessLevelSubProcessJavascript.getProcessData(), "subVar05:String:[]");
        EmbeddedSubprocess subProcessLevelSubProcessMVEL = (EmbeddedSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessMVEL.getGeneral(), "Embedded process06 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Embedded process06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEmbeddedSubprocessExecutionSet(subProcessLevelSubProcessMVEL.getExecutionSet(), true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_MVEL_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(subProcessLevelSubProcessMVEL.getProcessData(), "subVar06:String:[]");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelSubProcessWithEdges() {
        String SUB_PROCESS_NAME = "Sub-process08";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        EmbeddedSubprocess subProcessLevelSubProcess = (EmbeddedSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES, 2, 4);
        this.assertGeneralSet(subProcessLevelSubProcess.getGeneral(), "Sub-process08", "");
        this.assertEmbeddedSubprocessExecutionSet(subProcessLevelSubProcess.getExecutionSet(), false, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "");
        this.assertSubProcessProcessData(subProcessLevelSubProcess.getProcessData(), "");
    }

    @Override
    Class<EmbeddedSubprocess> getSubProcessType() {
        return EmbeddedSubprocess.class;
    }

    @Override
    String getBpmnSubProcessFilePath() {
        return BPMN_SUB_PROCESS_FILE_PATH;
    }

    @Override
    String getTopLevelEmptyPropertiesSubProcessId() {
        return TOP_LEVEL_EMPTY_SUBPROCESS_ID;
    }

    @Override
    String[] getTopLevelFilledPropertiesSubProcessesIds() {
        return new String[]{TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID, TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID};
    }

    @Override
    String getTopLevelSubProcessWithEdgesId() {
        return TOP_LEVEL_SUBPROCESS_WITH_EDGES;
    }

    @Override
    String getSubProcessLevelEmptyPropertiesSubProcessId() {
        return SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID;
    }

    @Override
    String[] getSubProcessLevelFilledPropertiesSubProcessesIds() {
        return new String[]{SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID};
    }

    @Override
    String getSubProcessLevelSubProcessWithEdgesId() {
        return SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES;
    }

    private void assertEmbeddedSubprocessExecutionSet(EmbeddedSubprocessExecutionSet executionSet, boolean isAsync, String onEntryActionScriptValue, String onEntryActionScriptLanguage, String onExitActionScriptValue, String onExitActionScriptLanguage, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getIsAsync()).isNotNull();
        Assertions.assertThat((Object)executionSet.getSlaDueDate()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnEntryAction()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnExitAction()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnEntryAction().getValue()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnExitAction().getValue()).isNotNull();
        List onEntryScriptTypeValues = executionSet.getOnEntryAction().getValue().getValues();
        List onExitScriptTypeValues = executionSet.getOnExitAction().getValue().getValues();
        Assertions.assertThat((List)onEntryScriptTypeValues).isNotNull();
        Assertions.assertThat((List)onExitScriptTypeValues).isNotNull();
        Assertions.assertThat(onEntryScriptTypeValues.get(0)).isNotNull();
        Assertions.assertThat(onExitScriptTypeValues.get(0)).isNotNull();
        Assertions.assertThat((Boolean)executionSet.getIsAsync().getValue()).isEqualTo(isAsync);
        Assertions.assertThat((String)executionSet.getSlaDueDate().getValue()).isEqualTo(slaDueDate);
        Assertions.assertThat((String)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getScript()).isEqualTo(onEntryActionScriptValue);
        Assertions.assertThat((String)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getLanguage()).isEqualTo(onEntryActionScriptLanguage);
        Assertions.assertThat((String)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getScript()).isEqualTo(onExitActionScriptValue);
        Assertions.assertThat((String)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getLanguage()).isEqualTo(onExitActionScriptLanguage);
    }

    @Test
    public void testMarshallEmbeddedCoords() throws Exception {
        String BPMN_EMBEDDED_SUBPROCESS = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/embeddedSubprocess.bpmn";
        String END_EVENT = "shape__FF050977-4D13-47F1-8B9B-D68FDE208666";
        Diagram<Graph, Metadata> diagram = this.getSpecificDiagram("org/kie/workbench/common/stunner/bpmn/backend/service/diagram/embeddedSubprocess.bpmn");
        DefinitionsConverter definitionsConverter = new DefinitionsConverter(diagram.getGraph());
        Definitions definitions = definitionsConverter.toDefinitions();
        List planeElement = ((BPMNDiagram)definitions.getDiagrams().get(0)).getPlane().getPlaneElement();
        BPMNShape diagramElement = planeElement.stream().filter(BPMNShape.class::isInstance).map(s -> (BPMNShape)s).filter(el -> el.getId().equals(END_EVENT)).findFirst().get();
        Assertions.assertThat((float)diagramElement.getBounds().getX()).isEqualTo(885.0f);
        Assertions.assertThat((float)diagramElement.getBounds().getY()).isEqualTo(143.0f);
    }
}

