/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks;

import java.io.ByteArrayInputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.DeclarationList;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks.TaskTest;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.UserTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.UserTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessVariables;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;

public class UserTaskTest
extends TaskTest<UserTask> {
    private static final String BPMN_TASK_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/userTasks.bpmn";
    private static final String MULTIPLE_DEFINITIONS_BPMN_TASK_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/multipleDefinitionsUserTask.bpmn";
    private static final String EMPTY_TOP_LEVEL_TASK_ID = "B740EDEB-E4EE-472C-BEF2-E3C01A7B1949";
    private static final String FILLED_TOP_LEVEL_TASK_JAVA_ID = "7799D66F-5754-4850-AF35-D60E78105D88";
    private static final String FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID = "38C9D3E0-CD8C-48A5-9359-F5A5B0421C59";
    private static final String FILLED_TOP_LEVEL_TASK_MVEL_ID = "5EEC84C3-2F1A-468A-942F-7BFFF2D20A94";
    private static final String EMPTY_SUBPROCESS_LEVEL_TASK_ID = "E8FD1C7D-EA48-4457-9DB3-3197990DC625";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID = "47301752-E893-43CB-9BD7-6E85BD8CDCCA";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "0179F9B7-B3F8-4804-B7A2-AFB48E21792B";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID = "6EA43C79-97AD-474B-935A-883825BA6B5D";
    private static final String EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID = "AA4C5ECB-DBF0-4679-AEA4-23FCDF8EC601";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID = "FDAC90A9-F7C1-496B-8265-EB915EB0C060";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "92901674-BE25-46E0-8FB5-1126F55FCE9A";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID = "025AD6AC-2355-4210-82C4-B897C3C5B95A";
    private static final String EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID = "90934E6B-51C9-445A-9D9B-BB389A457299";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID = "8EF57263-2946-4681-B638-F7985FCFCE56";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID = "95BE309A-38F7-4110-A460-ADFF3C14671A";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID = "42CAB178-389C-4141-B895-8ADFEBCFFAEC";
    private static final String EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID = "BD16C552-83E5-41DE-BB25-C78889712BDD";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID = "F9D87280-755F-4B68-A8D0-C9A788A8641A";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "3B82D4EC-2AF1-452E-81B9-CA65EEC2A114";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID = "F1AAE67C-22E6-4696-B78C-28144F43025D";
    private static final String EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID = "4B7F7377-E03A-40BA-B919-6649FF6512C5";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID = "A7D2CD45-16F0-47A1-B618-5D823DBC01DF";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID = "B60669F3-00B4-48BF-8B0A-EFA1F68E8963";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID = "BF8D305B-B143-4578-84D1-7BC540D0A51E";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 69;
    private static final String EMPTY_TASK_DATA_INPUT_OUTPUT = "|Skippable:Object|||";
    private static final String TASK_SCRIPT_JAVA_LANGUAGE = "java";
    private static final String TASK_SCRIPT_JAVASCRIPT_LANGUAGE = "javascript";
    private static final String TASK_SCRIPT_MVEL_LANGUAGE = "mvel";
    private static final boolean IS_ASYNC = true;
    private static final boolean IS_NOT_ASYNC = false;
    private static final boolean IS_SKIPPABLE = true;
    private static final boolean IS_NOT_SKIPPABLE = false;
    private static final boolean AD_HOC_AUTOSTART = true;
    private static final boolean NOT_AD_HOC_AUTOSTART = false;

    @Test
    public void RHBA607() throws Exception {
        super.init();
        String BPMN_USER_TASK_PROPERTIES_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/userTaskProperties.bpmn";
        String DIAGRAM_ID = "_pfJ-8O50EeiVSc03Fghuww";
        Diagram<Graph, Metadata> d = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/userTaskProperties.bpmn");
        Node node = d.getGraph().getNode("_pfJ-8O50EeiVSc03Fghuww");
        ProcessData processData = ((BPMNDiagramImpl)((View)node.getContent()).getDefinition()).getProcessData();
        ProcessVariables processVariables = processData.getProcessVariables();
        DeclarationList declarationList = DeclarationList.fromString((String)processVariables.getValue());
        Assert.assertTrue((boolean)declarationList.getDeclarations().isEmpty());
    }

    @Test
    public void testMultipleDefinitions() throws Exception {
        super.init();
        Diagram<Graph, Metadata> diagramBefore = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, MULTIPLE_DEFINITIONS_BPMN_TASK_FILE_PATH);
        String beforeReSave = this.getAssignmentsInfoValueOfTheFirstUserTask(diagramBefore.getGraph().nodes());
        Diagram<Graph, Metadata> diagramAfter = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, new ByteArrayInputStream(this.marshaller.marshall(diagramBefore).getBytes()));
        String afterReSave = this.getAssignmentsInfoValueOfTheFirstUserTask(diagramAfter.getGraph().nodes());
        String declaration = "inputVar:String";
        String association = "[dout]inputVar->processVar";
        Assert.assertEquals((long)2L, (long)this.countMatches(beforeReSave, declaration));
        Assert.assertEquals((long)2L, (long)this.countMatches(beforeReSave, association));
        Assert.assertEquals((long)1L, (long)this.countMatches(afterReSave, declaration));
        Assert.assertEquals((long)1L, (long)this.countMatches(afterReSave, association));
    }

    private int countMatches(String str, String subString) {
        return (str.length() - str.replace(subString, "").length()) / subString.length();
    }

    private String getAssignmentsInfoValueOfTheFirstUserTask(Iterable nodes) {
        for (Object node : nodes) {
            if (!(((ViewImpl)((NodeImpl)node).getContent()).getDefinition() instanceof UserTask)) continue;
            return ((UserTask)((ViewImpl)((NodeImpl)node).getContent()).getDefinition()).getExecutionSet().getAssignmentsinfo().getValue();
        }
        return "";
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyTaskProperties() {
        String TASK_NAME = "Task_1";
        String TASK_TASK_NAME = "Task";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask emptyTopLevelTask = (UserTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TOP_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "Task_1", "");
        this.assertUserTaskExecutionSet(emptyTopLevelTask.getExecutionSet(), "Task", "", "", "", false, false, "", "", "", false, EMPTY_TASK_DATA_INPUT_OUTPUT, "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, "", "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskOneIncomeEmptyProperties() {
        String TASK_NAME = "Task_2";
        String TASK_TASK_NAME = "Task";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask emptyTopLevelTask = (UserTask)this.getTaskNodeById(this.getDiagram(), EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "Task_2", "");
        this.assertUserTaskExecutionSet(emptyTopLevelTask.getExecutionSet(), "Task", "", "", "", false, false, "", "", "", false, EMPTY_TASK_DATA_INPUT_OUTPUT, "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, "", "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskTwoIncomesEmptyProperties() {
        String TASK_NAME = "Task_3";
        String TASK_TASK_NAME = "Task";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask emptyTopLevelTask = (UserTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "Task_3", "");
        this.assertUserTaskExecutionSet(emptyTopLevelTask.getExecutionSet(), "Task", "", "", "", false, false, "", "", "", false, EMPTY_TASK_DATA_INPUT_OUTPUT, "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, "", "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskFilledProperties() {
        String TASK_NAME_JAVA = "Task01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVA = "Task01ImplExecName";
        String TASK_SUBJECT_JAVA = "subject01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVA = "customUser";
        String TASK_GROUPS_JAVA = "customGroup";
        String TASK_PRIORITY_JAVA = "10";
        String TASK_DESCRIPTION_JAVA = "Task01 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVA = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action\");";
        String TASK_NAME_JAVASCRIPT = "Task04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVASCRIPT = "Task04ImplExecName";
        String TASK_SUBJECT_JAVASCRIPT = "subject04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVASCRIPT = "customUser";
        String TASK_GROUPS_JAVASCRIPT = "customGroup";
        String TASK_PRIORITY_JAVASCRIPT = "10";
        String TASK_DESCRIPTION_JAVASCRIPT = "Task04 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVASCRIPT = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action\");";
        String TASK_NAME_MVEL = "Task07 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_MVEL = "Task07ImplExecName";
        String TASK_SUBJECT_MVEL = "subject07 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_MVEL = "customUser";
        String TASK_GROUPS_MVEL = "customGroup";
        String TASK_PRIORITY_MVEL = "10";
        String TASK_DESCRIPTION_MVEL = "Task07 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_MVEL = "customUser";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action\");";
        String TASK_DATA_INPUT_OUTPUT_JAVA = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_JAVASCRIPT = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_MVEL = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_CONTENT_JAVA = "Content example. Top level. Java.";
        String TASK_CONTENT_JAVASCRIPT = "Content example. Top level. Javascript.";
        String TASK_CONTENT_MVEL = "Content example. Top level. MVEL.";
        String SLA_DUE_DATE = "25/12/1983";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask filledTopLevelTaskJava = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_JAVA_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "Task01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "Task01ImplExecName", "subject01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task01 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "Content example. Top level. Java.", "25/12/1983");
        UserTask filledTopLevelTaskJavascript = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "Task04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "Task04ImplExecName", "subject04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task04 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "console.log(\"On Entry Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "Content example. Top level. Javascript.", "25/12/1983");
        UserTask filledTopLevelTaskMvel = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_MVEL_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "Task07 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "Task07ImplExecName", "subject07 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task07 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "Content example. Top level. MVEL.", "25/12/1983");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskOneIncomeFilledProperties() {
        String TASK_NAME_JAVA = "Task02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVA = "Task02ImplExecName";
        String TASK_SUBJECT_JAVA = "subject02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVA = "customUser";
        String TASK_GROUPS_JAVA = "customGroup";
        String TASK_PRIORITY_JAVA = "10";
        String TASK_DESCRIPTION_JAVA = "Task02 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVA = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action\");";
        String TASK_NAME_JAVASCRIPT = "Task05 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVASCRIPT = "Task05ImplExecName";
        String TASK_SUBJECT_JAVASCRIPT = "subject05 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVASCRIPT = "customUser";
        String TASK_GROUPS_JAVASCRIPT = "customGroup";
        String TASK_PRIORITY_JAVASCRIPT = "10";
        String TASK_DESCRIPTION_JAVASCRIPT = "Task05 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVASCRIPT = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action\");";
        String TASK_NAME_MVEL = "Task08 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_MVEL = "Task08ImplExecName";
        String TASK_SUBJECT_MVEL = "subject08 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_MVEL = "customUser";
        String TASK_GROUPS_MVEL = "customGroup";
        String TASK_PRIORITY_MVEL = "10";
        String TASK_DESCRIPTION_MVEL = "Task08 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_MVEL = "customUser";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action\");";
        String TASK_DATA_INPUT_OUTPUT_JAVA = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_JAVASCRIPT = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_MVEL = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_CONTENT_JAVA = "Content example. Top level. One income. Java.";
        String TASK_CONTENT_JAVASCRIPT = "Content example. Top level. One income. Javascript.";
        String TASK_CONTENT_MVEL = "Content example. Top level. One income. MVEL.";
        String SLA_DUE_DATE = "25/12/1983";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask filledTopLevelTaskJava = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "Task02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "Task02ImplExecName", "subject02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task02 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "Content example. Top level. One income. Java.", "25/12/1983");
        UserTask filledTopLevelTaskJavascript = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "Task05 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "Task05ImplExecName", "subject05 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task05 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "console.log(\"On Entry Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "Content example. Top level. One income. Javascript.", "25/12/1983");
        UserTask filledTopLevelTaskMvel = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "Task08 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "Task08ImplExecName", "subject08 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task08 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "Content example. Top level. One income. MVEL.", "25/12/1983");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskTwoIncomesFilledProperties() {
        String TASK_NAME_JAVA = "Task03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVA = "Task03ImplExecName";
        String TASK_SUBJECT_JAVA = "subject03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVA = "customUser";
        String TASK_GROUPS_JAVA = "customGroup";
        String TASK_PRIORITY_JAVA = "10";
        String TASK_DESCRIPTION_JAVA = "Task03 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVA = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action\");";
        String TASK_NAME_JAVASCRIPT = "Task06 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVASCRIPT = "Task06ImplExecName";
        String TASK_SUBJECT_JAVASCRIPT = "subject06 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVASCRIPT = "customUser";
        String TASK_GROUPS_JAVASCRIPT = "customGroup";
        String TASK_PRIORITY_JAVASCRIPT = "10";
        String TASK_DESCRIPTION_JAVASCRIPT = "Task06 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVASCRIPT = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action\");";
        String TASK_NAME_MVEL = "Task09 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_MVEL = "Task09ImplExecName";
        String TASK_SUBJECT_MVEL = "subject09 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_MVEL = "customUser";
        String TASK_GROUPS_MVEL = "customGroup";
        String TASK_PRIORITY_MVEL = "10";
        String TASK_DESCRIPTION_MVEL = "Task09 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_MVEL = "customUser";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action\");";
        String TASK_DATA_INPUT_OUTPUT_JAVA = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_JAVASCRIPT = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_MVEL = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_CONTENT_JAVA = "Content example. Top level. Two incomes. Java.";
        String TASK_CONTENT_JAVASCRIPT = "Content example. Top level. Two incomes. Javascript.";
        String TASK_CONTENT_MVEL = "Content example. Top level. Two incomes. MVEL.";
        String SLA_DUE_DATE = "25/12/1983";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask filledTopLevelTaskJava = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "Task03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "Task03ImplExecName", "subject03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task03 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "Content example. Top level. Two incomes. Java.", "25/12/1983");
        UserTask filledTopLevelTaskJavascript = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "Task06 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "Task06ImplExecName", "subject06 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task06 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "console.log(\"On Entry Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "Content example. Top level. Two incomes. Javascript.", "25/12/1983");
        UserTask filledTopLevelTaskMvel = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "Task09 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "Task09ImplExecName", "subject09 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task09 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "Content example. Top level. Two incomes. MVEL.", "25/12/1983");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskEmptyProperties() {
        String TASK_NAME = "Task_4";
        String TASK_TASK_NAME = "Task";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask emptySubprocessLevelTask = (UserTask)this.getTaskNodeById(this.getDiagram(), EMPTY_SUBPROCESS_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "Task_4", "");
        this.assertUserTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet(), "Task", "", "", "", false, false, "", "", "", false, EMPTY_TASK_DATA_INPUT_OUTPUT, "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskOneIncomeEmptyProperties() {
        String TASK_NAME = "Task_5";
        String TASK_TASK_NAME = "Task";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask emptySubprocessLevelTask = (UserTask)this.getTaskNodeById(this.getDiagram(), EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "Task_5", "");
        this.assertUserTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet(), "Task", "", "", "", false, false, "", "", "", false, EMPTY_TASK_DATA_INPUT_OUTPUT, "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskTwoIncomesEmptyProperties() {
        String TASK_NAME = "Task_6";
        String TASK_TASK_NAME = "Task";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask emptySubprocessLevelTask = (UserTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "Task_6", "");
        this.assertUserTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet(), "Task", "", "", "", false, false, "", "", "", false, EMPTY_TASK_DATA_INPUT_OUTPUT, "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskFilledProperties() {
        String TASK_NAME_JAVA = "Task10 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVA = "Task10ImplExecName";
        String TASK_SUBJECT_JAVA = "subject10 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVA = "customUser";
        String TASK_GROUPS_JAVA = "customGroup";
        String TASK_PRIORITY_JAVA = "10";
        String TASK_DESCRIPTION_JAVA = "Task10 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVA = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action\");";
        String TASK_NAME_JAVASCRIPT = "Task13 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task13 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVASCRIPT = "Task13ImplExecName";
        String TASK_SUBJECT_JAVASCRIPT = "subject13 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVASCRIPT = "customUser";
        String TASK_GROUPS_JAVASCRIPT = "customGroup";
        String TASK_PRIORITY_JAVASCRIPT = "10";
        String TASK_DESCRIPTION_JAVASCRIPT = "Task13 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVASCRIPT = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action\");";
        String TASK_NAME_MVEL = "Task16 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task16 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_MVEL = "Task16ImplExecName";
        String TASK_SUBJECT_MVEL = "subject16 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_MVEL = "customUser";
        String TASK_GROUPS_MVEL = "customGroup";
        String TASK_PRIORITY_MVEL = "10";
        String TASK_DESCRIPTION_MVEL = "Task16 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_MVEL = "customUser";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action\");";
        String TASK_DATA_INPUT_OUTPUT_JAVA = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_JAVASCRIPT = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_MVEL = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_CONTENT_JAVA = "Content example. Sub-Process level. Java.";
        String TASK_CONTENT_JAVASCRIPT = "Content example. Sub-Process level. Javascript.";
        String TASK_CONTENT_MVEL = "Content example. Sub-Process level. MVEL.";
        String SLA_DUE_DATE = "25/12/1983";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask filledSubprocessLevelTaskJava = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "Task10 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "Task10ImplExecName", "subject10 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task10 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "Content example. Sub-Process level. Java.", "25/12/1983");
        UserTask filledSubprocessLevelTaskJavascript = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "Task13 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task13 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "Task13ImplExecName", "subject13 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task13 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "console.log(\"On Entry Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "Content example. Sub-Process level. Javascript.", "25/12/1983");
        UserTask filledSubprocessLevelTaskMvel = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "Task16 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task16 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "Task16ImplExecName", "subject16 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task16 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "Content example. Sub-Process level. MVEL.", "25/12/1983");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskOneIncomeFilledProperties() {
        String TASK_NAME_JAVA = "Task11 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVA = "Task11ImplExecName";
        String TASK_SUBJECT_JAVA = "subject11 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVA = "customUser";
        String TASK_GROUPS_JAVA = "customGroup";
        String TASK_PRIORITY_JAVA = "10";
        String TASK_DESCRIPTION_JAVA = "Task11 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVA = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action\");";
        String TASK_NAME_JAVASCRIPT = "Task14 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task14 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVASCRIPT = "Task14ImplExecName";
        String TASK_SUBJECT_JAVASCRIPT = "subject14 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVASCRIPT = "customUser";
        String TASK_GROUPS_JAVASCRIPT = "customGroup";
        String TASK_PRIORITY_JAVASCRIPT = "10";
        String TASK_DESCRIPTION_JAVASCRIPT = "Task14 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVASCRIPT = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action\");";
        String TASK_NAME_MVEL = "Task17 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task17 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_MVEL = "Task17ImplExecName";
        String TASK_SUBJECT_MVEL = "subject17 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_MVEL = "customUser";
        String TASK_GROUPS_MVEL = "customGroup";
        String TASK_PRIORITY_MVEL = "10";
        String TASK_DESCRIPTION_MVEL = "Task17 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_MVEL = "customUser";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action\");";
        String TASK_DATA_INPUT_OUTPUT_JAVA = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_JAVASCRIPT = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_MVEL = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_CONTENT_JAVA = "Content example. Sub-Process level. One income. Java.";
        String TASK_CONTENT_JAVASCRIPT = "Content example. Sub-Process level. One income. Javascript.";
        String TASK_CONTENT_MVEL = "Content example. Sub-Process level. One income. MVEL.";
        String SLA_DUE_DATE = "25/12/1983";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask filledSubprocessLevelTaskJava = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "Task11 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "Task11ImplExecName", "subject11 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task11 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "Content example. Sub-Process level. One income. Java.", "25/12/1983");
        UserTask filledSubprocessLevelTaskJavascript = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "Task14 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task14 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "Task14ImplExecName", "subject14 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task14 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "console.log(\"On Entry Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "Content example. Sub-Process level. One income. Javascript.", "25/12/1983");
        UserTask filledSubprocessLevelTaskMvel = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "Task17 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task17 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "Task17ImplExecName", "subject17 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task17 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "Content example. Sub-Process level. One income. MVEL.", "25/12/1983");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskTwoIncomesFilledProperties() {
        String TASK_NAME_JAVA = "Task12 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVA = "Task12ImplExecName";
        String TASK_SUBJECT_JAVA = "subject12 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVA = "customUser";
        String TASK_GROUPS_JAVA = "customGroup";
        String TASK_PRIORITY_JAVA = "10";
        String TASK_DESCRIPTION_JAVA = "Task12 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVA = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action\");";
        String TASK_NAME_JAVASCRIPT = "Task15 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task15 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_JAVASCRIPT = "Task15ImplExecName";
        String TASK_SUBJECT_JAVASCRIPT = "subject15 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_JAVASCRIPT = "customUser";
        String TASK_GROUPS_JAVASCRIPT = "customGroup";
        String TASK_PRIORITY_JAVASCRIPT = "10";
        String TASK_DESCRIPTION_JAVASCRIPT = "Task15 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_JAVASCRIPT = "customUser";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action\");";
        String TASK_NAME_MVEL = "Task18 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task18 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_TASK_NAME_MVEL = "Task18ImplExecName";
        String TASK_SUBJECT_MVEL = "subject18 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_ACTORS_MVEL = "customUser";
        String TASK_GROUPS_MVEL = "customGroup";
        String TASK_PRIORITY_MVEL = "10";
        String TASK_DESCRIPTION_MVEL = "Task18 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_CREATED_BY_MVEL = "customUser";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action\");";
        String TASK_DATA_INPUT_OUTPUT_JAVA = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_JAVASCRIPT = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_DATA_INPUT_OUTPUT_MVEL = "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        String TASK_CONTENT_JAVA = "Content example. Sub-Process level. Two incomes. Java.";
        String TASK_CONTENT_JAVASCRIPT = "Content example. Sub-Process level. Two incomes. Javascript.";
        String TASK_CONTENT_MVEL = "Content example. Sub-Process level. Two incomes. MVEL.";
        String SLA_DUE_DATE = "25/12/1983";
        this.assertDiagram(this.getDiagram(), 69);
        UserTask filledSubprocessLevelTaskJava = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "Task12 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "Task12ImplExecName", "subject12 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task12 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_JAVA_LANGUAGE, "Content example. Sub-Process level. Two incomes. Java.", "25/12/1983");
        UserTask filledSubprocessLevelTaskJavascript = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "Task15 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task15 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "Task15ImplExecName", "subject15 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task15 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "console.log(\"On Entry Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "Content example. Sub-Process level. Two incomes. Javascript.", "25/12/1983");
        UserTask filledSubprocessLevelTaskMvel = (UserTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "Task18 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task18 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertUserTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "Task18ImplExecName", "subject18 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "customUser", "customGroup", true, true, "10", "Task18 description\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "customUser", true, "|input:String,Skippable:Object,GroupId:Object,Comment:Object,Description:Object,Priority:Object,CreatedBy:Object,Content:Object||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar", "System.out.println(\"On Entry Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");", TASK_SCRIPT_MVEL_LANGUAGE, "Content example. Sub-Process level. Two incomes. MVEL.", "25/12/1983");
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskFilledProperties() {
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_JAVA_ID, 0, false);
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_MVEL_ID, 0, false);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskFilledProperties() {
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID, 0, false);
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID, 0, false);
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskOneIncomeFilledProperties() {
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID, 1, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskOneIncomeFilledProperties() {
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID, 1, true);
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskTwoIncomesFilledProperties() {
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID, 2, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskTwoIncomesFilledProperties() {
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID, 2, true);
    }

    @Override
    String getBpmnTaskFilePath() {
        return BPMN_TASK_FILE_PATH;
    }

    @Override
    Class<UserTask> getTaskType() {
        return UserTask.class;
    }

    @Override
    String getFilledTopLevelTaskId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskId() {
        return EMPTY_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskId() {
        return EMPTY_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getFilledTopLevelTaskOneIncomeId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskOneIncomeId() {
        return EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskOneIncomeId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskOneIncomeId() {
        return EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getFilledTopLevelTaskTwoIncomesId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskTwoIncomesId() {
        return EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskTwoIncomesId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskTwoIncomesId() {
        return EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID;
    }

    private void assertUserTaskExecutionSet(UserTaskExecutionSet executionSet, String taskName, String subject, String actors, String groupId, boolean isAsync, boolean skippable, String priority, String description, String createdBy, boolean adHocAutostart, String dataInputOutput, String onEntryActionScriptValue, String onEntryActionScriptLanguage, String onExitActionScriptValue, String onExitActionScriptLanguage, String content, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getTaskName());
        Assert.assertNotNull((Object)executionSet.getSubject());
        Assert.assertNotNull((Object)executionSet.getActors());
        Assert.assertNotNull((Object)executionSet.getGroupid());
        Assert.assertNotNull((Object)executionSet.getIsAsync());
        Assert.assertNotNull((Object)executionSet.getSkippable());
        Assert.assertNotNull((Object)executionSet.getPriority());
        Assert.assertNotNull((Object)executionSet.getDescription());
        Assert.assertNotNull((Object)executionSet.getCreatedBy());
        Assert.assertNotNull((Object)executionSet.getAdHocAutostart());
        Assert.assertNotNull((Object)executionSet.getAssignmentsinfo());
        Assert.assertNotNull((Object)executionSet.getOnEntryAction());
        Assert.assertNotNull((Object)executionSet.getOnExitAction());
        Assert.assertNotNull((Object)executionSet.getOnEntryAction().getValue());
        Assert.assertNotNull((Object)executionSet.getOnExitAction().getValue());
        List onEntryScriptTypeValues = executionSet.getOnEntryAction().getValue().getValues();
        List onExitScriptTypeValues = executionSet.getOnExitAction().getValue().getValues();
        Assert.assertNotNull((Object)onEntryScriptTypeValues);
        Assert.assertNotNull((Object)onExitScriptTypeValues);
        Assert.assertNotNull(onEntryScriptTypeValues.get(0));
        Assert.assertNotNull(onExitScriptTypeValues.get(0));
        Assert.assertNotNull((Object)executionSet.getContent().getValue());
        Assert.assertNotNull((Object)executionSet.getSlaDueDate().getValue());
        Assert.assertEquals((Object)taskName, (Object)executionSet.getTaskName().getValue());
        Assert.assertEquals((Object)subject, (Object)executionSet.getSubject().getValue());
        Assert.assertEquals((Object)actors, (Object)executionSet.getActors().getValue());
        Assert.assertEquals((Object)groupId, (Object)executionSet.getGroupid().getValue());
        Assert.assertEquals((Object)isAsync, (Object)executionSet.getIsAsync().getValue());
        Assert.assertEquals((Object)skippable, (Object)executionSet.getSkippable().getValue());
        Assert.assertEquals((Object)priority, (Object)executionSet.getPriority().getValue());
        Assert.assertEquals((Object)description, (Object)executionSet.getDescription().getValue());
        Assert.assertEquals((Object)createdBy, (Object)executionSet.getCreatedBy().getValue());
        Assert.assertEquals((Object)adHocAutostart, (Object)executionSet.getAdHocAutostart().getValue());
        Assert.assertEquals((Object)dataInputOutput, (Object)executionSet.getAssignmentsinfo().getValue());
        Assert.assertEquals((Object)onEntryActionScriptValue, (Object)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getScript());
        Assert.assertEquals((Object)onEntryActionScriptLanguage, (Object)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getLanguage());
        Assert.assertEquals((Object)onExitActionScriptValue, (Object)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getScript());
        Assert.assertEquals((Object)onExitActionScriptLanguage, (Object)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getLanguage());
        Assert.assertEquals((Object)content, (Object)executionSet.getContent().getValue());
        Assert.assertEquals((Object)slaDueDate, (Object)executionSet.getSlaDueDate().getValue());
    }
}

