/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem.deploy;

import java.util.Collection;
import java.util.function.BiFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.WorkItemDefinitionResources;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.deploy.WorkItemDefinitionDefaultDeployService;
import org.kie.workbench.common.stunner.core.backend.service.BackendFileSystemManager;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkItemDefinitionDefaultDeployServiceTest {
    @Mock
    private WorkItemDefinitionResources resources;
    @Mock
    private BackendFileSystemManager backendFileSystemManager;
    @Mock
    private Metadata metadata;
    @Mock
    private Path globalPath;
    @Mock
    private BiFunction<String, String, BackendFileSystemManager.Asset> assetBuilder;
    @Mock
    private BackendFileSystemManager.Asset widAsset;
    @Mock
    private BackendFileSystemManager.Asset brIcon;
    @Mock
    private BackendFileSystemManager.Asset decisionIcon;
    @Mock
    private BackendFileSystemManager.Asset logIcon;
    @Mock
    private BackendFileSystemManager.Asset emailIcon;
    @Mock
    private BackendFileSystemManager.Asset serviceNodeIcon;
    @Mock
    private BackendFileSystemManager.Asset milestoneNodeIcon;
    private WorkItemDefinitionDefaultDeployService tested;

    @Before
    public void init() {
        Mockito.when((Object)this.assetBuilder.apply((String)ArgumentMatchers.eq((Object)"WorkDefinitions.wid"), (String)ArgumentMatchers.eq((Object)WorkItemDefinitionDefaultDeployServiceTest.getClassPath("WorkDefinitions.wid")))).thenReturn((Object)this.widAsset);
        Mockito.when((Object)this.assetBuilder.apply((String)ArgumentMatchers.eq((Object)"defaultemailicon.png"), (String)ArgumentMatchers.eq((Object)WorkItemDefinitionDefaultDeployServiceTest.getClassPath("defaultemailicon.png")))).thenReturn((Object)this.emailIcon);
        Mockito.when((Object)this.assetBuilder.apply((String)ArgumentMatchers.eq((Object)"defaultbusinessruletaskicon.png"), (String)ArgumentMatchers.eq((Object)WorkItemDefinitionDefaultDeployServiceTest.getClassPath("defaultbusinessruletaskicon.png")))).thenReturn((Object)this.brIcon);
        Mockito.when((Object)this.assetBuilder.apply((String)ArgumentMatchers.eq((Object)"defaultdecisiontaskicon.png"), (String)ArgumentMatchers.eq((Object)WorkItemDefinitionDefaultDeployServiceTest.getClassPath("defaultdecisiontaskicon.png")))).thenReturn((Object)this.decisionIcon);
        Mockito.when((Object)this.assetBuilder.apply((String)ArgumentMatchers.eq((Object)"defaultlogicon.png"), (String)ArgumentMatchers.eq((Object)WorkItemDefinitionDefaultDeployServiceTest.getClassPath("defaultlogicon.png")))).thenReturn((Object)this.logIcon);
        Mockito.when((Object)this.assetBuilder.apply((String)ArgumentMatchers.eq((Object)"defaultservicenodeicon.png"), (String)ArgumentMatchers.eq((Object)WorkItemDefinitionDefaultDeployServiceTest.getClassPath("defaultservicenodeicon.png")))).thenReturn((Object)this.serviceNodeIcon);
        Mockito.when((Object)this.assetBuilder.apply((String)ArgumentMatchers.eq((Object)"defaultmilestoneicon.png"), (String)ArgumentMatchers.eq((Object)WorkItemDefinitionDefaultDeployServiceTest.getClassPath("defaultmilestoneicon.png")))).thenReturn((Object)this.milestoneNodeIcon);
        Mockito.when((Object)this.resources.resolveGlobalPath((Metadata)ArgumentMatchers.eq((Object)this.metadata))).thenReturn((Object)this.globalPath);
        this.tested = new WorkItemDefinitionDefaultDeployService(this.resources, this.backendFileSystemManager, this.assetBuilder);
    }

    @Test
    public void testDeployAssets() {
        ArgumentCaptor assetsArgumentCaptor = ArgumentCaptor.forClass(BackendFileSystemManager.Assets.class);
        this.tested.deploy(this.metadata);
        ((BackendFileSystemManager)Mockito.verify((Object)this.backendFileSystemManager, (VerificationMode)Mockito.times((int)1))).deploy((Path)ArgumentMatchers.eq((Object)this.globalPath), (BackendFileSystemManager.Assets)assetsArgumentCaptor.capture(), ArgumentMatchers.anyString());
        Collection assets = ((BackendFileSystemManager.Assets)assetsArgumentCaptor.getValue()).getAssets();
        Assert.assertEquals((long)WorkItemDefinitionDefaultDeployService.ASSETS.length, (long)assets.size());
        Assert.assertTrue((boolean)assets.contains(this.widAsset));
        Assert.assertTrue((boolean)assets.contains(this.emailIcon));
        Assert.assertTrue((boolean)assets.contains(this.brIcon));
        Assert.assertTrue((boolean)assets.contains(this.decisionIcon));
        Assert.assertTrue((boolean)assets.contains(this.logIcon));
        Assert.assertTrue((boolean)assets.contains(this.serviceNodeIcon));
        Assert.assertTrue((boolean)assets.contains(this.milestoneNodeIcon));
    }

    private static String getClassPath(String asset) {
        return "/META-INF/org/kie/workbench/common/stunner/bpmn/backend/workitem/" + asset;
    }
}

