/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.ArrayList;
import java.util.List;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class DDTAInputEntry {
    private final List<BaseNode> uts;
    private final List<Interval> intervals;

    public DDTAInputEntry(List<BaseNode> uts, List<Interval> intervals) {
        this.uts = uts;
        this.intervals = intervals;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.intervals);
        return builder.toString();
    }

    public List<BaseNode> getUts() {
        return this.uts;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public boolean includes(DDTAInputEntry other) {
        ArrayList<Interval> otherIntervals = new ArrayList<Interval>(other.intervals);
        for (Interval i : this.intervals) {
            ArrayList<Interval> includedInI = new ArrayList<Interval>();
            for (Interval o : otherIntervals) {
                if (!i.includes(o)) continue;
                includedInI.add(o);
            }
            otherIntervals.removeAll(includedInI);
        }
        return otherIntervals.isEmpty();
    }

    public boolean adjOrOverlap(DDTAInputEntry other) {
        return Interval.adjOrOverlap(this.intervals, other.intervals);
    }
}

