/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.core.util.MethodUtils;
import org.drools.mvelcompiler.ast.TypedExpression;

public class FieldToAccessorTExpr
implements TypedExpression {
    private final TypedExpression scope;
    private final Type type;
    private final Method accessor;
    private final List<TypedExpression> arguments;

    public FieldToAccessorTExpr(TypedExpression scope, Method accessor, List<TypedExpression> arguments) {
        this.scope = scope;
        this.accessor = accessor;
        this.type = this.parseType(accessor);
        this.arguments = arguments;
    }

    private Type parseType(Method accessor) {
        if (accessor.getParameterTypes().length == 1) {
            return accessor.getParameterTypes()[0];
        }
        return accessor.getGenericReturnType();
    }

    public FieldToAccessorTExpr(TypedExpression scope, Method accessor) {
        this(scope, accessor, Collections.emptyList());
    }

    @Override
    public Optional<Type> getType() {
        return Optional.of(this.type);
    }

    @Override
    public Node toJavaExpression() {
        List expressionArguments = this.arguments.stream().map(this::convertToStringIfNeeded).collect(Collectors.toList());
        return new MethodCallExpr((Expression)this.scope.toJavaExpression(), this.accessor.getName(), NodeList.nodeList(expressionArguments));
    }

    private Expression convertToStringIfNeeded(TypedExpression argumentExpression) {
        boolean argumentCanBeToStringed = argumentExpression.getType().filter(this::typeCanBeToStringed).isPresent();
        boolean fieldIsString = String.class.equals((Object)this.type);
        if (fieldIsString && argumentCanBeToStringed) {
            return new MethodCallExpr((Expression)new EnclosedExpr((Expression)argumentExpression.toJavaExpression()), "toString");
        }
        return (Expression)argumentExpression.toJavaExpression();
    }

    private Boolean typeCanBeToStringed(Type t) {
        if (t instanceof ParameterizedType) {
            return false;
        }
        Class clazz = (Class)t;
        boolean isNotPrimitive = !clazz.isPrimitive();
        boolean isNotString = !t.equals(String.class);
        boolean isNotNull = !t.equals(MethodUtils.NullType.class);
        return isNotString && isNotPrimitive && isNotNull;
    }

    public String toString() {
        return "FieldToAccessorTExpr{ scope=" + this.scope.toString() + ", type=" + this.type + ", accessor=" + this.accessor + '}';
    }
}

