/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.BaseCreateCommitTree;
import org.uberfire.java.nio.fs.jgit.util.model.MoveCommitContent;

public class CreateMoveCommitTree
extends BaseCreateCommitTree<MoveCommitContent> {
    public CreateMoveCommitTree(Git git, ObjectId headId, ObjectInserter inserter, MoveCommitContent commitContent) {
        super(git, headId, inserter, commitContent);
    }

    public Optional<ObjectId> execute() {
        Map<String, String> content = ((MoveCommitContent)this.commitContent).getContent();
        DirCacheEditor editor = DirCache.newInCore().editor();
        ArrayList pathsAdded = new ArrayList();
        try {
            this.iterateOverTreeWalk(this.git, this.headId, (walkPath, hTree) -> {
                String toPath = (String)content.get(walkPath);
                DirCacheEntry dcEntry = new DirCacheEntry(toPath == null ? walkPath : toPath);
                if (!pathsAdded.contains(dcEntry.getPathString())) {
                    this.addToTemporaryInCoreIndex(editor, dcEntry, hTree.getEntryObjectId(), hTree.getEntryFileMode());
                    pathsAdded.add(dcEntry.getPathString());
                }
            });
            editor.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.buildTree(editor);
    }
}

