/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.def;

import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.validation.groups.CSVDataSetDefFilePathValidation;
import org.dashbuilder.dataset.validation.groups.CSVDataSetDefFileURLValidation;
import org.dashbuilder.dataset.validation.groups.CSVDataSetDefValidation;

public class CSVDataSetDef
extends DataSetDef {
    @NotNull(groups={CSVDataSetDefFileURLValidation.class})
    @Size(min=1, groups={CSVDataSetDefFileURLValidation.class})
    protected @NotNull(groups={CSVDataSetDefFileURLValidation.class}) @Size(min=1, groups={CSVDataSetDefFileURLValidation.class}) String fileURL;
    @NotNull(groups={CSVDataSetDefFilePathValidation.class})
    @Size(min=1, groups={CSVDataSetDefFilePathValidation.class})
    protected @NotNull(groups={CSVDataSetDefFilePathValidation.class}) @Size(min=1, groups={CSVDataSetDefFilePathValidation.class}) String filePath;
    @NotNull(groups={CSVDataSetDefValidation.class})
    protected Character separatorChar;
    @NotNull(groups={CSVDataSetDefValidation.class})
    protected Character quoteChar;
    @NotNull(groups={CSVDataSetDefValidation.class})
    protected Character escapeChar;
    @NotNull(groups={CSVDataSetDefValidation.class})
    @Size(min=1, groups={CSVDataSetDefValidation.class})
    protected @NotNull(groups={CSVDataSetDefValidation.class}) @Size(min=1, groups={CSVDataSetDefValidation.class}) String datePattern = "MM-dd-yyyy HH:mm:ss";
    @NotNull(groups={CSVDataSetDefValidation.class})
    @Size(min=1, groups={CSVDataSetDefValidation.class})
    protected @NotNull(groups={CSVDataSetDefValidation.class}) @Size(min=1, groups={CSVDataSetDefValidation.class}) String numberPattern = "#,###.##";

    public CSVDataSetDef() {
        super.setProvider(DataSetProviderType.CSV);
        this.separatorChar = Character.valueOf(';');
        this.quoteChar = Character.valueOf('\'');
        this.escapeChar = Character.valueOf('\\');
    }

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String fileURL) {
        this.fileURL = fileURL;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Character getSeparatorChar() {
        return this.separatorChar;
    }

    public void setSeparatorChar(Character separatorChar) {
        this.separatorChar = separatorChar;
    }

    public Character getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(Character quoteChar) {
        this.quoteChar = quoteChar;
    }

    public Character getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(Character escapeChar) {
        this.escapeChar = escapeChar;
    }

    @Override
    public String getPattern(String columnId) {
        String p = super.getPattern(columnId);
        if (p != null) {
            return p;
        }
        DataColumnDef c = this.getColumnById(columnId);
        if (c == null) {
            return null;
        }
        if (c.getColumnType().equals((Object)ColumnType.NUMBER)) {
            return this.numberPattern;
        }
        if (c.getColumnType().equals((Object)ColumnType.DATE)) {
            return this.datePattern;
        }
        return null;
    }

    public String getNumberPattern() {
        return this.numberPattern;
    }

    public void setNumberPattern(String numberPattern) {
        this.numberPattern = numberPattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public String getDatePattern(String columnId) {
        String pattern = this.getPattern(columnId);
        return pattern == null ? this.datePattern : pattern;
    }

    public String getNumberPattern(String columnId) {
        String pattern = this.getPattern(columnId);
        return pattern == null ? this.numberPattern : pattern;
    }

    public char getNumberGroupSeparator(String columnId) {
        String pattern = this.getPattern(columnId);
        if (pattern == null) {
            pattern = this.numberPattern;
        }
        if (pattern.length() < 2) {
            return ',';
        }
        return pattern.charAt(1);
    }

    public char getNumberDecimalSeparator(String columnId) {
        String pattern = this.getPattern(columnId);
        if (pattern == null) {
            pattern = this.numberPattern;
        }
        if (pattern.length() < 6) {
            return '.';
        }
        return pattern.charAt(5);
    }

    @Override
    public boolean equals(Object obj) {
        try {
            CSVDataSetDef other = (CSVDataSetDef)obj;
            if (!super.equals(other)) {
                return false;
            }
            if (this.fileURL != null && !this.fileURL.equals(other.fileURL)) {
                return false;
            }
            if (this.filePath != null && !this.filePath.equals(other.filePath)) {
                return false;
            }
            if (this.separatorChar != null && !this.separatorChar.equals(other.separatorChar)) {
                return false;
            }
            if (this.quoteChar != null && !this.quoteChar.equals(other.quoteChar)) {
                return false;
            }
            if (this.datePattern != null && !this.datePattern.equals(other.datePattern)) {
                return false;
            }
            return this.numberPattern == null || this.numberPattern.equals(other.numberPattern);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fileURL, this.filePath, this.separatorChar, this.quoteChar, this.escapeChar, this.datePattern, this.numberPattern);
    }

    @Override
    public DataSetDef clone() {
        CSVDataSetDef def = new CSVDataSetDef();
        this.clone(def);
        def.setFilePath(this.getFilePath());
        def.setFileURL(this.getFileURL());
        def.setSeparatorChar(this.getSeparatorChar());
        def.setQuoteChar(this.getQuoteChar());
        def.setEscapeChar(this.getEscapeChar());
        def.setDatePattern(this.getDatePattern());
        def.setNumberPattern(this.getNumberPattern());
        return def;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("File=");
        if (this.filePath != null) {
            out.append(this.filePath);
        } else {
            out.append(this.fileURL);
        }
        out.append("\n");
        out.append("UUID=").append(this.UUID).append("\n");
        out.append("Provider=").append(this.provider).append("\n");
        out.append("Public=").append(this.isPublic).append("\n");
        out.append("Push enabled=").append(this.pushEnabled).append("\n");
        out.append("Push max size=").append(this.pushMaxSize).append(" Kb\n");
        if (this.refreshTime != null) {
            out.append("Refresh time=").append(this.refreshTime).append("\n");
            out.append("Refresh always=").append(this.refreshAlways).append("\n");
        }
        out.append("Separator char=").append(this.separatorChar).append("\n");
        out.append("Quote char=").append(this.quoteChar).append("\n");
        out.append("Escape char=").append(this.escapeChar).append("\n");
        out.append("Number pattern=").append(this.numberPattern).append("\n");
        out.append("Date pattern=").append(this.datePattern).append("\n");
        return out.toString();
    }
}

