/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDTGraphXMLPersistence;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphContent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableGraphEditorService;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableLinkManager;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableResourceTypeDefinition;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.DotFileFilter;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.backend.version.VersionRecordService;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class GuidedDecisionTableGraphEditorServiceImpl
extends KieService<GuidedDecisionTableEditorGraphContent>
implements GuidedDecisionTableGraphEditorService {
    private IOService ioService;
    private CopyService copyService;
    private DeleteService deleteService;
    private RenameService renameService;
    private KieModuleService moduleService;
    private VersionRecordService versionRecordService;
    private GuidedDecisionTableEditorService dtableService;
    private GuidedDecisionTableLinkManager dtableLinkManager;
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    private CommentedOptionFactory commentedOptionFactory;
    private GuidedDTableResourceTypeDefinition resourceType;
    private DotFileFilter dotFileFilter;
    private SafeSessionInfo safeSessionInfo;

    public GuidedDecisionTableGraphEditorServiceImpl() {
    }

    @Inject
    public GuidedDecisionTableGraphEditorServiceImpl(@Named(value="ioStrategy") IOService ioService, CopyService copyService, DeleteService deleteService, RenameService renameService, KieModuleService moduleService, VersionRecordService versionRecordService, GuidedDecisionTableEditorService dtableService, GuidedDecisionTableLinkManager dtableLinkManager, Event<ResourceOpenedEvent> resourceOpenedEvent, CommentedOptionFactory commentedOptionFactory, GuidedDTableResourceTypeDefinition resourceType, DotFileFilter dotFileFilter, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.copyService = copyService;
        this.deleteService = deleteService;
        this.renameService = renameService;
        this.moduleService = moduleService;
        this.versionRecordService = versionRecordService;
        this.dtableService = dtableService;
        this.dtableLinkManager = dtableLinkManager;
        this.resourceOpenedEvent = resourceOpenedEvent;
        this.commentedOptionFactory = commentedOptionFactory;
        this.resourceType = resourceType;
        this.dotFileFilter = dotFileFilter;
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, GuidedDecisionTableEditorGraphModel model, String comment) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            Set<org.uberfire.backend.vfs.Path> paths = this.getLinkedDecisionTablesInPackage(context);
            paths.forEach(path -> model.getEntries().add(new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry(path, this.getLatestVersionPath((org.uberfire.backend.vfs.Path)path))));
            this.ioService.write(nioPath, GuidedDTGraphXMLPersistence.getInstance().marshal(model), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedDecisionTableEditorGraphModel load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return GuidedDTGraphXMLPersistence.getInstance().unmarshal(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedDecisionTableEditorGraphContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (GuidedDecisionTableEditorGraphContent)super.loadContent(path);
    }

    protected GuidedDecisionTableEditorGraphContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        GuidedDecisionTableEditorGraphModel model = this.load(path);
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new GuidedDecisionTableEditorGraphContent(model, overview);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, GuidedDecisionTableEditorGraphModel model, Metadata metadata, String comment) {
        try {
            this.versionEntriesPaths(model);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), GuidedDTGraphXMLPersistence.getInstance().marshal(model), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private void versionEntriesPaths(GuidedDecisionTableEditorGraphModel model) {
        for (GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry entry : model.getEntries()) {
            entry.setPathVersion(this.getLatestVersionPath(entry.getPathHead()));
        }
    }

    private org.uberfire.backend.vfs.Path getLatestVersionPath(org.uberfire.backend.vfs.Path path) {
        List versions = this.versionRecordService.load(Paths.convert((org.uberfire.backend.vfs.Path)path));
        String versionUri = ((VersionRecord)versions.get(versions.size() - 1)).uri();
        return PathFactory.newPathBasedOn((String)path.getFileName(), (String)versionUri, (org.uberfire.backend.vfs.Path)path);
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<org.uberfire.backend.vfs.Path> listDecisionTablesInPackage(org.uberfire.backend.vfs.Path path) {
        try {
            Package pkg = this.moduleService.resolvePackage(path);
            if (pkg == null) {
                return Collections.emptyList();
            }
            org.uberfire.backend.vfs.Path pkgPath = pkg.getPackageMainResourcesPath();
            Path nioPkgPath = Paths.convert((org.uberfire.backend.vfs.Path)pkgPath);
            List<org.uberfire.backend.vfs.Path> paths = this.findDecisionTables(nioPkgPath);
            return paths;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private List<org.uberfire.backend.vfs.Path> findDecisionTables(Path nioRootPath) {
        ArrayList<org.uberfire.backend.vfs.Path> paths = new ArrayList<org.uberfire.backend.vfs.Path>();
        try (DirectoryStream directoryStream = this.ioService.newDirectoryStream(nioRootPath);){
            for (Path nioPath : directoryStream) {
                org.uberfire.backend.vfs.Path path = Paths.convert((Path)nioPath);
                if (this.dotFileFilter.accept(nioPath) || !this.resourceType.accept(path)) continue;
                paths.add(path);
            }
        }
        return paths;
    }

    private Set<org.uberfire.backend.vfs.Path> getLinkedDecisionTablesInPackage(org.uberfire.backend.vfs.Path context) {
        HashSet<org.uberfire.backend.vfs.Path> linkedDecisionTablePaths = new HashSet<org.uberfire.backend.vfs.Path>();
        List<org.uberfire.backend.vfs.Path> allDecisionTablePathsInPackage = this.listDecisionTablesInPackage(context);
        ArrayList allDecisionTablesInPackage = new ArrayList();
        allDecisionTablePathsInPackage.forEach(path -> allDecisionTablesInPackage.add(new Pair(path, this.dtableService.load(path))));
        allDecisionTablesInPackage.forEach(source -> {
            ArrayList otherDecisionTablesInPackage = new ArrayList();
            otherDecisionTablesInPackage.addAll(allDecisionTablesInPackage);
            otherDecisionTablesInPackage.remove(source);
            otherDecisionTablesInPackage.forEach(target -> this.dtableLinkManager.link((GuidedDecisionTable52)source.getK2(), (GuidedDecisionTable52)target.getK2(), (s, t) -> {
                linkedDecisionTablePaths.add((org.uberfire.backend.vfs.Path)source.getK1());
                linkedDecisionTablePaths.add((org.uberfire.backend.vfs.Path)target.getK1());
            }));
        });
        return linkedDecisionTablePaths;
    }
}

