/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion.util;

import org.drools.workbench.models.datamodel.rule.ActionCallMethod;
import org.drools.workbench.models.datamodel.rule.ActionFieldList;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;

public class BRLColumnUtil {
    private BRLColumnUtil() {
    }

    public static boolean canThisColumnBeSplitToMultiple(BRLActionColumn brlColumn) {
        for (IAction iAction : brlColumn.getDefinition()) {
            if (!BRLColumnUtil.onlyActionFieldListIsAccepted(iAction) && !BRLColumnUtil.validateActionFieldValues((ActionFieldList)iAction)) continue;
            return false;
        }
        return true;
    }

    public static boolean canThisColumnBeSplitToMultiple(BRLConditionColumn brlColumn) {
        for (IPattern iPattern : brlColumn.getDefinition()) {
            if (!BRLColumnUtil.onlyFactPatternsAreAccepted(iPattern) && !BRLColumnUtil.validateFactPatternConstraints(((FactPattern)iPattern).getConstraintList().getConstraints())) continue;
            return false;
        }
        return true;
    }

    private static boolean validateActionFieldValues(ActionFieldList iAction) {
        for (ActionFieldValue fieldValue : iAction.getFieldValues()) {
            if (iAction instanceof ActionCallMethod || !BRLColumnUtil.onlyAllowedActionFieldValueTypeIsTemplateType(fieldValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean validateFactPatternConstraints(FieldConstraint[] constraints) {
        for (FieldConstraint constraint : constraints) {
            if (BRLColumnUtil.acceptOnlySingleFieldConstraints(constraint)) {
                return true;
            }
            if (BRLColumnUtil.useOfExpressionsIsNotAllowed(constraint)) {
                return true;
            }
            if (!BRLColumnUtil.onlyAllowedConstraintValueTypeIsTemplateType(constraint)) continue;
            return true;
        }
        return false;
    }

    private static boolean onlyAllowedActionFieldValueTypeIsTemplateType(ActionFieldValue fieldValue) {
        return fieldValue.getNature() != 7;
    }

    private static boolean onlyActionFieldListIsAccepted(IAction iAction) {
        return !(iAction instanceof ActionFieldList);
    }

    private static boolean onlyFactPatternsAreAccepted(IPattern iPattern) {
        return !(iPattern instanceof FactPattern);
    }

    private static boolean onlyAllowedConstraintValueTypeIsTemplateType(FieldConstraint fieldConstraint) {
        return fieldConstraint instanceof SingleFieldConstraint && ((SingleFieldConstraint)fieldConstraint).getConstraintValueType() != 7;
    }

    private static boolean useOfExpressionsIsNotAllowed(FieldConstraint fieldConstraint) {
        return fieldConstraint instanceof SingleFieldConstraint && !((SingleFieldConstraint)fieldConstraint).getExpressionValue().isEmpty();
    }

    private static boolean acceptOnlySingleFieldConstraints(FieldConstraint constraint) {
        if (constraint instanceof CompositeFieldConstraint) {
            if (constraint != null && ((CompositeFieldConstraint)constraint).getConstraints() != null) {
                for (FieldConstraint fieldConstraint : ((CompositeFieldConstraint)constraint).getConstraints()) {
                    if (BRLColumnUtil.acceptOnlySingleFieldConstraints(fieldConstraint)) continue;
                    return false;
                }
            }
        } else if (constraint instanceof SingleFieldConstraint) {
            return false;
        }
        return true;
    }
}

