/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion.util;

import java.util.Objects;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RuleNameColumn;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.NotificationReporter;
import org.drools.workbench.screens.guided.dtable.shared.XLSConversionResultMessage;
import org.drools.workbench.screens.guided.dtable.shared.XLSConversionResultMessageType;

public class Skipper {
    private Skipper() {
    }

    public static boolean shouldSkip(NotificationReporter notificationReporter, BaseColumn baseColumn) {
        if (baseColumn instanceof RowNumberCol52) {
            return true;
        }
        if (baseColumn instanceof RuleNameColumn) {
            notificationReporter.report(new XLSConversionResultMessage(XLSConversionResultMessageType.RULE_NAME_NOT_CONVERTED, "Rule Name column conversion is not supported yet. Conversion ignored this column."));
            return true;
        }
        if (Skipper.isDialect(baseColumn)) {
            notificationReporter.report(new XLSConversionResultMessage(XLSConversionResultMessageType.DIALECT_NOT_CONVERTED, "Dialect is not a supported column type in XLS Decision tables. Conversion ignored this column."));
            return true;
        }
        return false;
    }

    public static boolean isDialect(BaseColumn baseColumn) {
        return baseColumn instanceof AttributeCol52 && Objects.equals(((AttributeCol52)baseColumn).getAttribute(), Attribute.DIALECT.getAttributeName());
    }
}

