/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.HasTypeRefs;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClauseText;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.definition.model.common.HasTypeRefHelper;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
public class DecisionRule
extends DMNElement
implements HasTypeRefs {
    private List<UnaryTests> inputEntry;
    private List<LiteralExpression> outputEntry;
    private List<RuleAnnotationClauseText> annotationEntry;

    public DecisionRule() {
        this(new Id(), new Description(), null, null);
    }

    public DecisionRule(Id id, Description description, List<UnaryTests> inputEntry, List<LiteralExpression> outputEntry) {
        super(id, description);
        this.inputEntry = inputEntry;
        this.outputEntry = outputEntry;
    }

    public DecisionRule copy() {
        DecisionRule clonedDecisionRule = new DecisionRule();
        clonedDecisionRule.description = Optional.ofNullable(this.description).map(Description::copy).orElse(null);
        clonedDecisionRule.inputEntry = this.inputEntry.stream().map(UnaryTests::copy).collect(Collectors.toList());
        clonedDecisionRule.outputEntry = this.outputEntry.stream().map(LiteralExpression::copy).collect(Collectors.toList());
        clonedDecisionRule.annotationEntry = Optional.ofNullable(this.annotationEntry).map(annotationEntryList -> annotationEntryList.stream().map(RuleAnnotationClauseText::copy).collect(Collectors.toList())).orElse(null);
        return clonedDecisionRule;
    }

    public List<RuleAnnotationClauseText> getAnnotationEntry() {
        if (this.annotationEntry == null) {
            this.annotationEntry = new ArrayList<RuleAnnotationClauseText>();
        }
        return this.annotationEntry;
    }

    public List<UnaryTests> getInputEntry() {
        if (this.inputEntry == null) {
            this.inputEntry = new ArrayList<UnaryTests>();
        }
        return this.inputEntry;
    }

    public List<LiteralExpression> getOutputEntry() {
        if (this.outputEntry == null) {
            this.outputEntry = new ArrayList<LiteralExpression>();
        }
        return this.outputEntry;
    }

    @Override
    public List<HasTypeRef> getHasTypeRefs() {
        return new ArrayList<HasTypeRef>(HasTypeRefHelper.getFlatHasTypeRefs(this.getOutputEntry()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecisionRule)) {
            return false;
        }
        DecisionRule that = (DecisionRule)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.inputEntry != null ? !this.inputEntry.equals(that.inputEntry) : that.inputEntry != null) {
            return false;
        }
        if (this.annotationEntry != null ? !this.annotationEntry.equals(that.annotationEntry) : that.annotationEntry != null) {
            return false;
        }
        return this.outputEntry != null ? this.outputEntry.equals(that.outputEntry) : that.outputEntry == null;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.id != null ? this.id.hashCode() : 0, this.description != null ? this.description.hashCode() : 0, this.inputEntry != null ? this.inputEntry.hashCode() : 0, this.outputEntry != null ? this.outputEntry.hashCode() : 0, this.annotationEntry != null ? this.annotationEntry.hashCode() : 0});
    }
}

