/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.rules;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtensionHandler;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;
import org.kie.workbench.common.stunner.core.rule.violations.RuleViolationImpl;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
public class SingleConnectorPerTypeGraphRule
extends RuleExtensionHandler<SingleConnectorPerTypeGraphRule, GraphConnectionContext> {
    static final String ERROR_MESSAGE = "Connection would violate single connection per type requirement.";

    public Class<SingleConnectorPerTypeGraphRule> getExtensionType() {
        return SingleConnectorPerTypeGraphRule.class;
    }

    public Class<GraphConnectionContext> getContextType() {
        return GraphConnectionContext.class;
    }

    public boolean accepts(RuleExtension rule, GraphConnectionContext context) {
        Object o = DefinitionUtils.getElementDefinition((Element)context.getConnector());
        Class type = rule.getTypeArguments()[0];
        return o.getClass().equals(type);
    }

    public RuleViolations evaluate(RuleExtension rule, GraphConnectionContext context) {
        Edge connector;
        Node target;
        Optional oSource = context.getSource();
        Optional oTarget = context.getTarget();
        DefaultRuleViolations result = new DefaultRuleViolations();
        if (!oSource.isPresent() || !oTarget.isPresent()) {
            return result;
        }
        Node source = (Node)oSource.get();
        if (this.isConnectionAlreadyFormed(source, target = (Node)oTarget.get(), connector = context.getConnector())) {
            result.addViolation((RuleViolation)new RuleViolationImpl(ERROR_MESSAGE));
        }
        return result;
    }

    protected boolean isConnectionAlreadyFormed(Node<? extends View<?>, ? extends Edge> source, Node<? extends View<?>, ? extends Edge> target, Edge<? extends View<?>, ? extends Node> connector) {
        Class<?> newConnectorClass = ((View)connector.getContent()).getDefinition().getClass();
        return source.getOutEdges().stream().filter(e -> !Objects.equals(e, connector)).flatMap(e -> {
            Class<?> existingConnectorClass;
            Object content = e.getContent();
            if (content instanceof Definition && newConnectorClass.equals(existingConnectorClass = ((Definition)content).getDefinition().getClass())) {
                return Stream.of(e);
            }
            return Stream.empty();
        }).distinct().map(Edge::getTargetNode).anyMatch(n -> Objects.equals(n, target));
    }
}

