/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.commons.factories.KiePMMLModelFactory;
import org.kie.pmml.evaluator.assembler.rulemapping.PMMLRuleMapper;
import org.kie.pmml.evaluator.assembler.rulemapping.PMMLRuleMappers;
import org.kie.pmml.evaluator.assembler.service.PMMLAssemblerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLLoaderService {
    private static final Logger logger = LoggerFactory.getLogger(PMMLLoaderService.class);

    private PMMLLoaderService() {
    }

    public static List<KiePMMLModel> getKiePMMLModelsLoadedFromResourcesWithConfigurations(KnowledgeBuilderImpl kbuilderImpl, Collection<ResourceWithConfiguration> resourceWithConfigurations) {
        return resourceWithConfigurations.stream().map(ResourceWithConfiguration::getResource).flatMap(resource -> PMMLLoaderService.getKiePMMLModelsLoadedFromResource(kbuilderImpl, resource).stream()).collect(Collectors.toList());
    }

    public static List<KiePMMLModel> getKiePMMLModelsLoadedFromResource(KnowledgeBuilderImpl kbuilderImpl, Resource resource) {
        try {
            KiePMMLModelFactory aClass = PMMLLoaderService.loadKiePMMLModelFactory(kbuilderImpl, resource);
            return PMMLLoaderService.getKiePMMLModelsLoadedFromFactory(kbuilderImpl, aClass);
        }
        catch (ClassNotFoundException e) {
            logger.info(String.format("KiePMMLModelFactory class for %s not found in rootClassLoader, going to compile model", resource.getSourcePath()));
        }
        catch (Exception e) {
            throw new KiePMMLException("Exception while instantiating KiePMMLModelFactory for " + resource.getSourcePath(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public static KiePMMLModelFactory loadKiePMMLModelFactory(KnowledgeBuilderImpl kbuilderImpl, Resource resource) throws Exception {
        String[] classNamePackageName = PMMLAssemblerService.getFactoryClassNamePackageName(resource);
        String factoryClassName = classNamePackageName[0];
        String packageName = classNamePackageName[1];
        String fullFactoryClassName = packageName + "." + factoryClassName;
        return PMMLLoaderService.loadKiePMMLModelFactory(kbuilderImpl.getRootClassLoader(), fullFactoryClassName);
    }

    public static List<PMMLRuleMapper> getPMMLRuleMappers(KnowledgeBuilderImpl kbuilderImpl, KiePMMLModelFactory modelFactory) {
        ArrayList<PMMLRuleMapper> toReturn = new ArrayList<PMMLRuleMapper>();
        for (KiePMMLModel kiePMMLModel : modelFactory.getKiePMMLModels()) {
            toReturn.addAll(PMMLLoaderService.loadPMMLRuleMappers(kbuilderImpl.getRootClassLoader(), kiePMMLModel.getKModulePackageName()));
            if (!(kiePMMLModel instanceof HasNestedModels)) continue;
            PMMLLoaderService.populatePMMLRuleMappers(kbuilderImpl, ((HasNestedModels)kiePMMLModel).getNestedModels(), toReturn);
        }
        return toReturn;
    }

    static List<KiePMMLModel> getKiePMMLModelsLoadedFromFactory(KnowledgeBuilderImpl kbuilderImpl, KiePMMLModelFactory kiePMMLModelFactory) {
        List toReturn = kiePMMLModelFactory.getKiePMMLModels();
        ArrayList<PMMLRuleMapper> pmmlRuleMappers = new ArrayList<PMMLRuleMapper>();
        PMMLLoaderService.populatePMMLRuleMappers(kbuilderImpl, toReturn, pmmlRuleMappers);
        PMMLLoaderService.loadPMMLRuleMappers(kbuilderImpl, pmmlRuleMappers);
        return toReturn;
    }

    static void populatePMMLRuleMappers(KnowledgeBuilderImpl kbuilderImpl, List<KiePMMLModel> kiePMMLModels, List<PMMLRuleMapper> toPopulate) {
        for (KiePMMLModel kiePMMLModel : kiePMMLModels) {
            toPopulate.addAll(PMMLLoaderService.loadPMMLRuleMappers(kbuilderImpl.getRootClassLoader(), kiePMMLModel.getKModulePackageName()));
            if (!(kiePMMLModel instanceof HasNestedModels)) continue;
            PMMLLoaderService.populatePMMLRuleMappers(kbuilderImpl, ((HasNestedModels)kiePMMLModel).getNestedModels(), toPopulate);
        }
    }

    static void loadPMMLRuleMappers(KnowledgeBuilderImpl kbuilderImpl, List<PMMLRuleMapper> pmmlRuleMappers) {
        if (!pmmlRuleMappers.isEmpty()) {
            List models = pmmlRuleMappers.stream().map(PMMLRuleMapper::getModel).collect(Collectors.toList());
            KnowledgeBuilderImpl temp = new KnowledgeBuilderImpl(KieBaseBuilder.createKieBaseFromModel(models, (KieBaseOption[])new KieBaseOption[0]));
            for (KiePackage kiePackage : temp.getKnowledgeBase().getKiePackages()) {
                kbuilderImpl.addPackage((InternalKnowledgePackage)kiePackage);
            }
        }
    }

    private static KiePMMLModelFactory loadKiePMMLModelFactory(ClassLoader classLoader, String fullFactoryClassName) throws Exception {
        Class<?> aClass = classLoader.loadClass(fullFactoryClassName);
        return (KiePMMLModelFactory)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static List<PMMLRuleMapper> loadPMMLRuleMappers(ClassLoader classLoader, String packageName) {
        Optional<PMMLRuleMappers> pmmlRuleMappers = PMMLLoaderService.loadPMMLRuleMappersClass(classLoader, packageName);
        return pmmlRuleMappers.map(PMMLRuleMappers::getPMMLRuleMappers).orElse(Collections.emptyList());
    }

    private static Optional<PMMLRuleMappers> loadPMMLRuleMappersClass(ClassLoader classLoader, String packageName) {
        String fullPMMLRuleMappersClassName = packageName + "." + "PMMLRuleMappersImpl";
        try {
            PMMLRuleMappers pmmlRuleMappers = (PMMLRuleMappers)classLoader.loadClass(fullPMMLRuleMappersClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return Optional.of(pmmlRuleMappers);
        }
        catch (ClassNotFoundException e) {
            logger.debug("{} class not found in rootClassLoader", (Object)fullPMMLRuleMappersClassName);
            return Optional.empty();
        }
        catch (Exception e) {
            throw new KiePMMLException(String.format("%s class not instantiable", fullPMMLRuleMappersClassName), (Throwable)e);
        }
    }
}

