/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.casemgmt.cmmn.core.Decision;
import org.jbpm.casemgmt.cmmn.core.Definitions;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DefinitionsHandler
extends BaseAbstractHandler
implements Handler {
    public DefinitionsHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(null);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        return new Definitions();
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Definitions definitions = (Definitions)parser.getCurrent();
        String id = element.getAttribute("id");
        String namespace = element.getAttribute("targetNamespace");
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        List processes = ((ProcessBuildData)parser.getData()).getProcesses();
        String namespaceN1 = (String)parser.getNamespaceURI("ns2");
        for (Process process : processes) {
            RuleFlowProcess ruleFlowProcess = (RuleFlowProcess)process;
            ruleFlowProcess.setMetaData("TargetNamespace", (Object)namespace);
            this.postProcessNodes(ruleFlowProcess, (NodeContainer)ruleFlowProcess, buildData, parser);
        }
        definitions.setId(id);
        definitions.setTargetNamespace(namespace);
        return definitions;
    }

    public Class<?> generateNodeFor() {
        return Definitions.class;
    }

    private void postProcessNodes(RuleFlowProcess process, NodeContainer container, ProcessBuildData buildData, ExtensibleXmlParser parser) {
        for (Node node : container.getNodes()) {
            if (node instanceof SubProcessNode) {
                Map processes = (Map)buildData.getMetaData("ProcessElements");
                if (processes != null) {
                    SubProcessNode subprocessNode = (SubProcessNode)node;
                    subprocessNode.setProcessId(processes.getOrDefault(subprocessNode.getProcessId(), subprocessNode.getProcessId()));
                }
            } else if (node instanceof RuleSetNode) {
                Map decisions = (Map)buildData.getMetaData("DecisionElements");
                RuleSetNode ruleSetNode = (RuleSetNode)node;
                if (decisions != null && decisions.containsKey(ruleSetNode.getRuleFlowGroup())) {
                    Decision decision = (Decision)decisions.get(ruleSetNode.getRuleFlowGroup());
                    ruleSetNode.setRuleFlowGroup(null);
                    ruleSetNode.setLanguage("http://www.jboss.org/drools/dmn");
                    ruleSetNode.setNamespace((String)parser.getNamespaceURI(decision.getNamespace()));
                    ruleSetNode.setModel(decision.getModel());
                    ruleSetNode.setDecision(decision.getDecision());
                }
            }
            if (!(node instanceof NodeContainer)) continue;
            this.postProcessNodes(process, (NodeContainer)node, buildData, parser);
        }
    }
}

