/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreProcess {
    private static final Logger logger = LoggerFactory.getLogger(PreProcess.class);

    private PreProcess() {
    }

    public static List<KiePMMLNameValue> preProcess(KiePMMLModel model, PMMLContext context) {
        PreProcess.addMissingValuesReplacements(model, context);
        PMMLRequestData requestData = context.getRequestData();
        Map mappedRequestParams = requestData.getMappedRequestParams();
        List<KiePMMLNameValue> kiePMMLNameValues = PreProcess.getKiePMMLNameValuesFromParameterInfos(mappedRequestParams.values());
        PreProcess.executeTransformations(model, requestData, kiePMMLNameValues);
        return kiePMMLNameValues;
    }

    static void addMissingValuesReplacements(KiePMMLModel model, PMMLContext context) {
        logger.debug("addMissingValuesReplacements {} {}", (Object)model, (Object)context);
        PMMLRequestData requestData = context.getRequestData();
        Map mappedRequestParams = requestData.getMappedRequestParams();
        Map missingValueReplacementMap = model.getMissingValueReplacementMap();
        missingValueReplacementMap.forEach((fieldName, missingValueReplacement) -> {
            if (!mappedRequestParams.containsKey(fieldName)) {
                logger.debug("missingValueReplacement {} {}", fieldName, missingValueReplacement);
                requestData.addRequestParam(fieldName, missingValueReplacement);
                context.addMissingValueReplaced(fieldName, missingValueReplacement);
            }
        });
    }

    static void executeTransformations(KiePMMLModel model, PMMLRequestData requestData, List<KiePMMLNameValue> kiePMMLNameValues) {
        logger.debug("executeTransformations {} {}", (Object)model, (Object)requestData);
        ArrayList derivedFields = new ArrayList();
        ArrayList defineFunctions = new ArrayList();
        if (model.getTransformationDictionary() != null) {
            if (model.getTransformationDictionary().getDerivedFields() != null) {
                derivedFields.addAll(model.getTransformationDictionary().getDerivedFields());
            }
            if (model.getTransformationDictionary().getDefineFunctions() != null) {
                defineFunctions.addAll(model.getTransformationDictionary().getDefineFunctions());
            }
        }
        if (model.getLocalTransformations() != null && model.getLocalTransformations().getDerivedFields() != null) {
            derivedFields.addAll(model.getLocalTransformations().getDerivedFields());
        }
        for (KiePMMLDerivedField derivedField : derivedFields) {
            Object derivedValue = derivedField.evaluate(defineFunctions, derivedFields, Collections.emptyList(), kiePMMLNameValues);
            if (derivedValue == null) continue;
            requestData.addRequestParam(derivedField.getName(), derivedValue);
            kiePMMLNameValues.add(new KiePMMLNameValue(derivedField.getName(), derivedValue));
        }
    }

    static List<KiePMMLNameValue> getKiePMMLNameValuesFromParameterInfos(Collection<ParameterInfo> parameterInfos) {
        return parameterInfos.stream().map(parameterInfo -> new KiePMMLNameValue(parameterInfo.getName(), parameterInfo.getValue())).collect(Collectors.toList());
    }
}

