/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.documentation.model.general;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsType;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessVariableSerializer;
import org.kie.workbench.common.stunner.core.client.util.js.KeyValue;

@JsType(isNative=true, namespace="<global>", name="Object")
public class ProcessVariablesTotal {
    private Integer total;
    private Integer totalVariables;
    private KeyValue[] variables;
    private VariableTriplets[] tripplets;

    private ProcessVariablesTotal() {
    }

    @JsOverlay
    public static final ProcessVariablesTotal create(Integer total, Integer totalVariables, KeyValue[] variables) {
        ProcessVariablesTotal instance = new ProcessVariablesTotal();
        instance.total = total;
        instance.totalVariables = totalVariables;
        instance.variables = variables;
        instance.tripplets = instance.getVariablesAsTriplets();
        return instance;
    }

    @JsOverlay
    public final Integer getTotal() {
        return this.total;
    }

    @JsOverlay
    public final Integer getTotalVariables() {
        return this.totalVariables;
    }

    @JsOverlay
    public final KeyValue[] getVariables() {
        return this.variables;
    }

    @JsOverlay
    public final VariableTriplets[] getVariablesAsTriplets() {
        VariableTriplets[] triplets = new VariableTriplets[this.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            ProcessVariableSerializer.VariableInfo info = (ProcessVariableSerializer.VariableInfo)this.variables[i].getValue();
            triplets[i] = VariableTriplets.create(this.variables[i].getKey(), info.getType(), info.getTags());
        }
        return triplets;
    }

    @JsType(isNative=true, namespace="<global>", name="Object")
    public static class VariableTriplets {
        private Object name;
        private Object type;
        private Object tags;

        private VariableTriplets() {
        }

        @JsOverlay
        public static final VariableTriplets create(Object name, Object type, Object tags) {
            VariableTriplets instance = new VariableTriplets();
            instance.name = name;
            instance.type = type;
            instance.tags = tags;
            return instance;
        }

        @JsOverlay
        public final Object getName() {
            return this.name;
        }

        @JsOverlay
        public final Object getType() {
            return this.type;
        }

        @JsOverlay
        public final Object getTags() {
            return this.tags;
        }
    }
}

