/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.powermock.core.classloader.ByteCodeFramework;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.classloader.MockClassLoaderConfiguration;
import org.powermock.core.classloader.annotations.UseClassPathAdjuster;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.MockTransformerChain;
import org.powermock.core.transformers.MockTransformerChainFactory;
import org.powermock.core.transformers.TestClassAwareTransformer;
import org.powermock.core.transformers.support.FilterPredicates;
import org.powermock.utils.ArrayUtil;
import org.powermock.utils.Asserts;

public class MockClassLoaderBuilder {
    private final MockTransformerChainFactory transformerChainFactory;
    private final List<MockTransformer> extraMockTransformers;
    private final ByteCodeFramework byteCodeFramework;
    private String[] packagesToIgnore;
    private String[] classesToModify;
    private UseClassPathAdjuster useClassPathAdjuster;
    private Class<?> testClass;

    public static MockClassLoaderBuilder create(ByteCodeFramework byteCodeFramework) {
        return new MockClassLoaderBuilder(byteCodeFramework);
    }

    private MockClassLoaderBuilder(ByteCodeFramework byteCodeFramework) {
        this.byteCodeFramework = byteCodeFramework;
        this.transformerChainFactory = byteCodeFramework.createTransformerChainFactory();
        this.extraMockTransformers = new ArrayList<MockTransformer>();
    }

    public MockClassLoader build() {
        Asserts.internalAssertNotNull(this.testClass, "Test class is null during building classloader. ");
        MockClassLoaderConfiguration configuration = new MockClassLoaderConfiguration(this.classesToModify, this.packagesToIgnore);
        MockClassLoader classLoader = this.byteCodeFramework.createClassloader(configuration, this.useClassPathAdjuster);
        classLoader.setMockTransformerChain(this.createTransformerChain());
        return classLoader;
    }

    private MockTransformerChain createTransformerChain() {
        MockTransformerChain mockTransformerChain = this.transformerChainFactory.createDefaultChain(this.extraMockTransformers);
        Collection<MockTransformer> testAwareTransformer = mockTransformerChain.filter(FilterPredicates.isInstanceOf(TestClassAwareTransformer.class));
        for (MockTransformer transformer : testAwareTransformer) {
            ((TestClassAwareTransformer)((Object)transformer)).setTestClass(this.testClass);
        }
        return mockTransformerChain;
    }

    public MockClassLoaderBuilder addIgnorePackage(String[] packagesToIgnore) {
        this.packagesToIgnore = ArrayUtil.addAll(this.packagesToIgnore, packagesToIgnore);
        return this;
    }

    public MockClassLoaderBuilder addClassesToModify(String[] classesToModify) {
        this.classesToModify = ArrayUtil.addAll(this.classesToModify, classesToModify);
        return this;
    }

    public MockClassLoaderBuilder addExtraMockTransformers(MockTransformer ... mockTransformers) {
        if (mockTransformers != null) {
            for (MockTransformer mockTransformer : mockTransformers) {
                if (mockTransformer == null) continue;
                this.extraMockTransformers.add(mockTransformer);
            }
        }
        return this;
    }

    public MockClassLoaderBuilder addClassPathAdjuster(UseClassPathAdjuster useClassPathAdjuster) {
        this.useClassPathAdjuster = useClassPathAdjuster;
        return this;
    }

    public MockClassLoaderBuilder forTestClass(Class<?> testClass) {
        this.testClass = testClass;
        return this;
    }
}

