/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.javassist;

import java.util.List;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.MockTransformerChain;
import org.powermock.core.transformers.MockTransformerChainFactory;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.javassist.ClassFinalModifierMockTransformer;
import org.powermock.core.transformers.javassist.ConstructorsMockTransformer;
import org.powermock.core.transformers.javassist.InstrumentMockTransformer;
import org.powermock.core.transformers.javassist.MethodSizeMockTransformer;
import org.powermock.core.transformers.javassist.PackagePrivateClassesMockTransformer;
import org.powermock.core.transformers.javassist.StaticFinalFieldsMockTransformer;
import org.powermock.core.transformers.javassist.StaticFinalNativeMethodMockTransformer;
import org.powermock.core.transformers.javassist.SuppressStaticInitializerMockTransformer;
import org.powermock.core.transformers.support.DefaultMockTransformerChain;

public class JavassistMockTransformerChainFactory
implements MockTransformerChainFactory {
    private static final TransformStrategy DEFAULT = TransformStrategy.CLASSLOADER;

    @Override
    public MockTransformerChain createDefaultChain() {
        return this.createDefaultChain(DEFAULT);
    }

    @Override
    public MockTransformerChain createDefaultChain(TransformStrategy transformStrategy) {
        return this.createDefaultChainBuilder(transformStrategy).build();
    }

    @Override
    public MockTransformerChain createDefaultChain(List<MockTransformer> extraMockTransformers) {
        return this.createDefaultChainBuilder(DEFAULT).append(extraMockTransformers).build();
    }

    @Override
    public MockTransformerChain createTestClassChain(MockTransformer testClassTransformer) {
        return this.createDefaultChainBuilder(DEFAULT).append(testClassTransformer).build();
    }

    private DefaultMockTransformerChain.MockTransformerChainBuilder createDefaultChainBuilder(TransformStrategy transformStrategy) {
        return DefaultMockTransformerChain.newBuilder().append(new ClassFinalModifierMockTransformer(transformStrategy)).append(new ConstructorsMockTransformer(transformStrategy)).append(new InstrumentMockTransformer(transformStrategy)).append(new PackagePrivateClassesMockTransformer(transformStrategy)).append(new StaticFinalFieldsMockTransformer(transformStrategy)).append(new StaticFinalNativeMethodMockTransformer(transformStrategy)).append(new SuppressStaticInitializerMockTransformer(transformStrategy)).append(new MethodSizeMockTransformer(transformStrategy));
    }
}

