/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.powermock.core.classloader.MockClassLoaderFactory;
import org.powermock.core.classloader.annotations.PrepareEverythingForTest;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.PrepareOnlyThisForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.core.transformers.TestClassTransformer;
import org.powermock.core.transformers.TestClassTransformerBuilder;
import org.powermock.tests.utils.TestChunk;
import org.powermock.tests.utils.TestSuiteChunker;
import org.powermock.tests.utils.impl.TestCaseEntry;
import org.powermock.tests.utils.impl.TestChunkImpl;

public abstract class AbstractCommonTestSuiteChunkerImpl
implements TestSuiteChunker {
    protected static final int NOT_INITIALIZED = -1;
    static final int DEFAULT_TEST_LISTENERS_SIZE = 1;
    static final int INTERNAL_INDEX_NOT_FOUND = -1;
    private final List<TestCaseEntry> internalSuites = new LinkedList<TestCaseEntry>();
    final LinkedHashMap<Integer, List<Integer>> testAtDelegateMapper = new LinkedHashMap();
    final Class<?>[] testClasses;
    private int currentTestIndex = -1;

    protected AbstractCommonTestSuiteChunkerImpl(Class<?> testClass) throws Exception {
        this(new Class[]{testClass});
    }

    AbstractCommonTestSuiteChunkerImpl(Class<?> ... testClasses) throws Exception {
        this.testClasses = testClasses;
        for (Class<?> clazz : testClasses) {
            this.chunkClass(clazz);
        }
    }

    @Override
    public int getChunkSize() {
        return this.getTestChunks().size();
    }

    @Override
    public List<TestChunk> getTestChunks() {
        LinkedList<TestChunk> allChunks = new LinkedList<TestChunk>();
        for (TestCaseEntry entry : this.internalSuites) {
            allChunks.addAll(entry.getTestChunks());
        }
        return allChunks;
    }

    @Override
    public List<TestChunk> getTestChunksEntries(Class<?> testClass) {
        for (TestCaseEntry entry : this.internalSuites) {
            if (!entry.getTestClass().equals(testClass)) continue;
            return entry.getTestChunks();
        }
        return null;
    }

    @Override
    public TestChunk getTestChunk(Method method) {
        for (TestChunk testChunk : this.getTestChunks()) {
            if (!testChunk.isMethodToBeExecutedByThisClassloader(method)) continue;
            return testChunk;
        }
        return null;
    }

    private void chunkClass(Class<?> testClass) throws Exception {
        ArrayList<Method> testMethodsForOtherClassLoaders = new ArrayList<Method>();
        ClassLoader defaultMockLoader = this.createDefaultMockLoader(testClass, testMethodsForOtherClassLoaders);
        LinkedList<Method> currentClassloaderMethods = new LinkedList<Method>();
        TestChunkImpl defaultTestChunk = new TestChunkImpl(defaultMockLoader, currentClassloaderMethods);
        LinkedList<TestChunk> testChunks = new LinkedList<TestChunk>();
        testChunks.add(defaultTestChunk);
        this.internalSuites.add(new TestCaseEntry(testClass, testChunks));
        this.initEntries(this.internalSuites);
        if (!currentClassloaderMethods.isEmpty()) {
            List<TestChunk> allTestChunks = this.internalSuites.get(0).getTestChunks();
            for (TestChunk chunk : allTestChunks.subList(1, allTestChunks.size())) {
                testMethodsForOtherClassLoaders.addAll(chunk.getTestMethodsToBeExecutedByThisClassloader());
            }
        } else if (2 <= this.internalSuites.size() || 1 == this.internalSuites.size() && 2 <= this.internalSuites.get(0).getTestChunks().size()) {
            this.internalSuites.get(0).getTestChunks().remove(0);
        }
    }

    private ClassLoader createDefaultMockLoader(Class<?> testClass, Collection<Method> testMethodsForOtherClassLoaders) {
        TestClassTransformer extraMockTransformer = null == this.testMethodAnnotation() ? null : TestClassTransformerBuilder.forTestClass(testClass).removesTestMethodAnnotation(this.testMethodAnnotation()).fromMethods(testMethodsForOtherClassLoaders);
        return new MockClassLoaderFactory(testClass).createForClass(extraMockTransformer);
    }

    private void putMethodToChunk(TestCaseEntry testCaseEntry, Class<?> testClass, Method method) {
        if (this.shouldExecuteTestForMethod(testClass, method)) {
            ++this.currentTestIndex;
            if (this.hasChunkAnnotation(method)) {
                LinkedList<Method> methodsInThisChunk = new LinkedList<Method>();
                methodsInThisChunk.add(method);
                ClassLoader mockClassloader = this.createClassLoaderForMethod(testClass, method);
                TestChunkImpl chunk = new TestChunkImpl(mockClassloader, methodsInThisChunk);
                testCaseEntry.getTestChunks().add(chunk);
                this.updatedIndexes();
            } else {
                testCaseEntry.getTestChunks().get(0).getTestMethodsToBeExecutedByThisClassloader().add(method);
                int currentDelegateIndex = this.internalSuites.size() - 1;
                List<Integer> testList = this.testAtDelegateMapper.get(currentDelegateIndex);
                if (testList == null) {
                    testList = new LinkedList<Integer>();
                    this.testAtDelegateMapper.put(currentDelegateIndex, testList);
                }
                testList.add(this.currentTestIndex);
            }
        }
    }

    private ClassLoader createClassLoaderForMethod(Class<?> testClass, Method method) {
        TestClassTransformer extraMockTransformer = null == this.testMethodAnnotation() ? null : TestClassTransformerBuilder.forTestClass(testClass).bytecodeFrameworkClue(method).removesTestMethodAnnotation(this.testMethodAnnotation()).fromAllMethodsExcept(method);
        MockClassLoaderFactory classLoaderFactory = new MockClassLoaderFactory(testClass);
        return classLoaderFactory.createForMethod(method, extraMockTransformer);
    }

    protected Class<? extends Annotation> testMethodAnnotation() {
        return null;
    }

    private void initEntries(List<TestCaseEntry> entries) {
        for (TestCaseEntry testCaseEntry : entries) {
            Class<?> testClass = testCaseEntry.getTestClass();
            this.findMethods(testCaseEntry, testClass);
        }
    }

    private void findMethods(TestCaseEntry testCaseEntry, Class<?> testClass) {
        Method[] allMethods;
        for (Method method : allMethods = testClass.getMethods()) {
            this.putMethodToChunk(testCaseEntry, testClass, method);
        }
        if (!Object.class.equals(testClass = testClass.getSuperclass())) {
            this.findMethods(testCaseEntry, testClass);
        }
    }

    private boolean hasChunkAnnotation(Method method) {
        return method.isAnnotationPresent(PrepareForTest.class) || method.isAnnotationPresent(SuppressStaticInitializationFor.class) || method.isAnnotationPresent(PrepareOnlyThisForTest.class) || method.isAnnotationPresent(PrepareEverythingForTest.class);
    }

    private void updatedIndexes() {
        LinkedList<Integer> testIndexesForThisClassloader = new LinkedList<Integer>();
        testIndexesForThisClassloader.add(this.currentTestIndex);
        this.testAtDelegateMapper.put(this.internalSuites.size(), testIndexesForThisClassloader);
    }
}

