/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.whitelist;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.backend.file.AntPathMatcher;
import org.kie.workbench.common.services.shared.whitelist.WhiteList;

public class PackageNameWhiteListFilter {
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private final Collection<String> packageNames;
    private final Set<String> patterns;

    public PackageNameWhiteListFilter(Collection<String> packageNames, WhiteList whiteList) {
        this.packageNames = (Collection)PortablePreconditions.checkNotNull((String)"packageNames", packageNames);
        PortablePreconditions.checkNotNull((String)"whitelist", (Object)whiteList);
        this.patterns = this.makePatterns(whiteList);
    }

    private Set<String> makePatterns(WhiteList whiteList) {
        HashSet<String> patterns = new HashSet<String>();
        for (String packageName : whiteList) {
            patterns.add(packageName.replaceAll("\\.", "/"));
        }
        return patterns;
    }

    public WhiteList getFilteredPackageNames() {
        WhiteList whiteList = new WhiteList();
        HashMap<String, String> packageNamePatterns = this.getPatterns();
        for (String pattern : this.patterns) {
            for (Map.Entry packageNamePath : packageNamePatterns.entrySet()) {
                if (!ANT_PATH_MATCHER.match(pattern, (String)packageNamePath.getValue())) continue;
                whiteList.add((String)packageNamePath.getKey());
            }
        }
        return whiteList;
    }

    private HashMap<String, String> getPatterns() {
        HashMap<String, String> packageNamePaths = new HashMap<String, String>();
        for (String packageName : this.packageNames) {
            packageNamePaths.put(packageName, packageName.replaceAll("\\.", "/"));
        }
        return packageNamePaths;
    }
}

