/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.types.query;

import java.util.Set;
import java.util.function.Predicate;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.kie.workbench.common.dmn.backend.editors.types.query.DMNValueFileExtensionIndexTerm;
import org.kie.workbench.common.dmn.backend.editors.types.query.DMNValueRepositoryRootIndexTerm;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.FileDetailsResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.AbstractFindQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@ApplicationScoped
public class FindAllDmnAssetsQuery
extends AbstractFindQuery
implements NamedQuery {
    public static String NAME = "FindAllDmnAssetsQuery";
    private final FileDetailsResponseBuilder responseBuilder;

    @Inject
    public FindAllDmnAssetsQuery(FileDetailsResponseBuilder responseBuilder) {
        this.responseBuilder = responseBuilder;
    }

    public String getName() {
        return NAME;
    }

    public Query toQuery(Set<ValueIndexTerm> terms) {
        this.checkNotNullAndNotEmpty(terms);
        return this.buildFromMultipleTerms(terms);
    }

    public Sort getSortOrder() {
        return new Sort(new SortField("filenamesorted", SortField.Type.STRING));
    }

    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    public void validateTerms(Set<ValueIndexTerm> queryTerms) throws IllegalArgumentException {
        this.checkTerms(queryTerms, NAME, this.requiredTermNames(), this.repositoryRootIndexTermPredicate(), this.fileExtensionIndexTermPredicate());
        this.checkTermsSize(2, queryTerms);
    }

    void checkTerms(Set<ValueIndexTerm> queryTerms, String name, String[] requiredTermNames, Predicate<ValueIndexTerm> repositoryRootIndexTermPredicate, Predicate<ValueIndexTerm> fileExtensionIndexTermPredicate) {
        this.checkInvalidAndRequiredTerms(queryTerms, name, requiredTermNames, new Predicate[]{repositoryRootIndexTermPredicate, fileExtensionIndexTermPredicate});
    }

    Predicate<ValueIndexTerm> fileExtensionIndexTermPredicate() {
        return t -> t instanceof DMNValueFileExtensionIndexTerm;
    }

    Predicate<ValueIndexTerm> repositoryRootIndexTermPredicate() {
        return t -> t instanceof DMNValueRepositoryRootIndexTerm;
    }

    String[] requiredTermNames() {
        return new String[]{"libraryRepositoryRoot", "libraryFileName"};
    }
}

