/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.backend.fluent.AddCoverageListenerCommand;
import org.drools.scenariosimulation.backend.fluent.CoverageAgendaListener;
import org.drools.scenariosimulation.backend.fluent.FactCheckerHandle;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.ValidateFactCommand;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;

public class RuleStatelessScenarioExecutableBuilder
implements RuleScenarioExecutableBuilder {
    private final KieContainer kieContainer;
    private final String sessionName;
    private final List<Object> inputs = new ArrayList<Object>();
    private final Map<FactIdentifier, List<FactCheckerHandle>> internalConditions = new HashMap<FactIdentifier, List<FactCheckerHandle>>();
    private final KieCommands commands = KieServices.get().getCommands();
    private String agendaGroup;

    protected RuleStatelessScenarioExecutableBuilder(KieContainer kieContainer, String sessionName) {
        this.kieContainer = kieContainer;
        this.sessionName = sessionName;
    }

    @Override
    public void addInternalCondition(Class<?> clazz, Function<Object, ValueWrapper> checkFunction, ScenarioResult scenarioResult) {
        this.internalConditions.computeIfAbsent(scenarioResult.getFactIdentifier(), key -> new ArrayList()).add(new FactCheckerHandle(clazz, checkFunction, scenarioResult));
    }

    @Override
    public void setActiveAgendaGroup(String agendaGroup) {
        this.agendaGroup = agendaGroup;
    }

    @Override
    public void setActiveRuleFlowGroup(String ruleFlowGroup) {
        this.agendaGroup = ruleFlowGroup;
    }

    @Override
    public void insert(Object element) {
        this.inputs.add(element);
    }

    @Override
    public Map<String, Object> run() {
        StatelessKieSession statelessKieSession = this.kieContainer.newStatelessKieSession(this.sessionName);
        CoverageAgendaListener coverageAgendaListener = new CoverageAgendaListener();
        statelessKieSession.execute(this.generateCommands(coverageAgendaListener));
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("COVERAGE_LISTENER", (Object)coverageAgendaListener);
        toReturn.put("RULES_AVAILABLE", this.getAvailableRules(statelessKieSession.getKieBase(), this.agendaGroup));
        return toReturn;
    }

    protected Command<ExecutionResults> generateCommands(CoverageAgendaListener coverageAgendaListener) {
        ArrayList<AddCoverageListenerCommand> toReturn = new ArrayList<AddCoverageListenerCommand>();
        toReturn.add(new AddCoverageListenerCommand(coverageAgendaListener));
        if (this.agendaGroup != null) {
            toReturn.add((AddCoverageListenerCommand)this.commands.newAgendaGroupSetFocus(this.agendaGroup));
        }
        if (!this.inputs.isEmpty()) {
            toReturn.add((AddCoverageListenerCommand)this.commands.newInsertElements(this.inputs));
        }
        toReturn.add((AddCoverageListenerCommand)this.commands.newFireAllRules());
        this.internalConditions.values().forEach(factToCheck -> toReturn.add((AddCoverageListenerCommand)((Object)new ValidateFactCommand((List<FactCheckerHandle>)factToCheck))));
        return this.commands.newBatchExecution(toReturn);
    }
}

