package org.jresearch.gwt.locale.langtag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LangTag}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLangTag.builder()}.
 */
@Generated(from = "LangTag", generator = "Immutables")
@SuppressWarnings({"static-method", "nls", "all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableLangTag extends LangTag {
  private final String primaryLanguage;
  private final List<String> languageSubtags;
  private final String script;
  private final String region;
  private final List<String> variants;
  private final List<String> extensions;
  private final String privateUse;

  private ImmutableLangTag(ImmutableLangTag.Builder builder) {
    this.languageSubtags = createUnmodifiableList(true, builder.languageSubtags);
    this.variants = createUnmodifiableList(true, builder.variants);
    this.extensions = createUnmodifiableList(true, builder.extensions);
    if (builder.primaryLanguage != null) {
      initShim.primaryLanguage(builder.primaryLanguage);
    }
    if (builder.script != null) {
      initShim.script(builder.script);
    }
    if (builder.region != null) {
      initShim.region(builder.region);
    }
    if (builder.privateUse != null) {
      initShim.privateUse(builder.privateUse);
    }
    this.primaryLanguage = initShim.primaryLanguage();
    this.script = initShim.script();
    this.region = initShim.region();
    this.privateUse = initShim.privateUse();
    this.initShim = null;
  }

  private ImmutableLangTag(
      String primaryLanguage,
      List<String> languageSubtags,
      String script,
      String region,
      List<String> variants,
      List<String> extensions,
      String privateUse) {
    this.primaryLanguage = primaryLanguage;
    this.languageSubtags = languageSubtags;
    this.script = script;
    this.region = region;
    this.variants = variants;
    this.extensions = extensions;
    this.privateUse = privateUse;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "LangTag", generator = "Immutables")
  private final class InitShim {
    private byte primaryLanguageBuildStage = STAGE_UNINITIALIZED;
    private String primaryLanguage;

    String primaryLanguage() {
      if (primaryLanguageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (primaryLanguageBuildStage == STAGE_UNINITIALIZED) {
        primaryLanguageBuildStage = STAGE_INITIALIZING;
        this.primaryLanguage = Objects.requireNonNull(ImmutableLangTag.super.primaryLanguage(), "primaryLanguage");
        primaryLanguageBuildStage = STAGE_INITIALIZED;
      }
      return this.primaryLanguage;
    }

    void primaryLanguage(String primaryLanguage) {
      this.primaryLanguage = primaryLanguage;
      primaryLanguageBuildStage = STAGE_INITIALIZED;
    }

    private byte scriptBuildStage = STAGE_UNINITIALIZED;
    private String script;

    String script() {
      if (scriptBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (scriptBuildStage == STAGE_UNINITIALIZED) {
        scriptBuildStage = STAGE_INITIALIZING;
        this.script = Objects.requireNonNull(ImmutableLangTag.super.script(), "script");
        scriptBuildStage = STAGE_INITIALIZED;
      }
      return this.script;
    }

    void script(String script) {
      this.script = script;
      scriptBuildStage = STAGE_INITIALIZED;
    }

    private byte regionBuildStage = STAGE_UNINITIALIZED;
    private String region;

    String region() {
      if (regionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (regionBuildStage == STAGE_UNINITIALIZED) {
        regionBuildStage = STAGE_INITIALIZING;
        this.region = Objects.requireNonNull(ImmutableLangTag.super.region(), "region");
        regionBuildStage = STAGE_INITIALIZED;
      }
      return this.region;
    }

    void region(String region) {
      this.region = region;
      regionBuildStage = STAGE_INITIALIZED;
    }

    private byte privateUseBuildStage = STAGE_UNINITIALIZED;
    private String privateUse;

    String privateUse() {
      if (privateUseBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (privateUseBuildStage == STAGE_UNINITIALIZED) {
        privateUseBuildStage = STAGE_INITIALIZING;
        this.privateUse = Objects.requireNonNull(ImmutableLangTag.super.privateUse(), "privateUse");
        privateUseBuildStage = STAGE_INITIALIZED;
      }
      return this.privateUse;
    }

    void privateUse(String privateUse) {
      this.privateUse = privateUse;
      privateUseBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (primaryLanguageBuildStage == STAGE_INITIALIZING) attributes.add("primaryLanguage");
      if (scriptBuildStage == STAGE_INITIALIZING) attributes.add("script");
      if (regionBuildStage == STAGE_INITIALIZING) attributes.add("region");
      if (privateUseBuildStage == STAGE_INITIALIZING) attributes.add("privateUse");
      return "Cannot build LangTag, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The primary language, as the shortest ISO 639 code (2*3ALPHA). Must always be
   * defined, unless sufficient language subtags exist.
   */
  @Override
  public String primaryLanguage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.primaryLanguage()
        : this.primaryLanguage;
  }

  /**
   * Optional extended language subtags, as three-letter ISO-639-3 codes.
   */
  @Override
  public List<String> languageSubtags() {
    return languageSubtags;
  }

  /**
   * Optional script, (4ALPHA) ISO 15924 code.
   */
  @Override
  public String script() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.script()
        : this.script;
  }

  /**
   * Optional region, (2ALPHA) ISO 3166-1 code or (3DIGIT) UN M.49 code.
   */
  @Override
  public String region() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.region()
        : this.region;
  }

  /**
   * Optional variants, (5*8alphanum) or (DIGIT 3alphanum).
   */
  @Override
  public List<String> variants() {
    return variants;
  }

  /**
   * Optional extensions.
   */
  @Override
  public List<String> extensions() {
    return extensions;
  }

  /**
   * Optional private use subtag.
   */
  @Override
  public String privateUse() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.privateUse()
        : this.privateUse;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LangTag#primaryLanguage() primaryLanguage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for primaryLanguage
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLangTag withPrimaryLanguage(String value) {
    String newValue = Objects.requireNonNull(value, "primaryLanguage");
    if (this.primaryLanguage.equals(newValue)) return this;
    return validate(new ImmutableLangTag(
        newValue,
        this.languageSubtags,
        this.script,
        this.region,
        this.variants,
        this.extensions,
        this.privateUse));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LangTag#languageSubtags() languageSubtags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLangTag withLanguageSubtags(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableLangTag(
        this.primaryLanguage,
        newValue,
        this.script,
        this.region,
        this.variants,
        this.extensions,
        this.privateUse));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LangTag#languageSubtags() languageSubtags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of languageSubtags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLangTag withLanguageSubtags(Iterable<String> elements) {
    if (this.languageSubtags == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableLangTag(
        this.primaryLanguage,
        newValue,
        this.script,
        this.region,
        this.variants,
        this.extensions,
        this.privateUse));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LangTag#script() script} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for script
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLangTag withScript(String value) {
    String newValue = Objects.requireNonNull(value, "script");
    if (this.script.equals(newValue)) return this;
    return validate(new ImmutableLangTag(
        this.primaryLanguage,
        this.languageSubtags,
        newValue,
        this.region,
        this.variants,
        this.extensions,
        this.privateUse));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LangTag#region() region} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for region
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLangTag withRegion(String value) {
    String newValue = Objects.requireNonNull(value, "region");
    if (this.region.equals(newValue)) return this;
    return validate(new ImmutableLangTag(
        this.primaryLanguage,
        this.languageSubtags,
        this.script,
        newValue,
        this.variants,
        this.extensions,
        this.privateUse));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LangTag#variants() variants}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLangTag withVariants(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableLangTag(
        this.primaryLanguage,
        this.languageSubtags,
        this.script,
        this.region,
        newValue,
        this.extensions,
        this.privateUse));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LangTag#variants() variants}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of variants elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLangTag withVariants(Iterable<String> elements) {
    if (this.variants == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableLangTag(
        this.primaryLanguage,
        this.languageSubtags,
        this.script,
        this.region,
        newValue,
        this.extensions,
        this.privateUse));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LangTag#extensions() extensions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLangTag withExtensions(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableLangTag(
        this.primaryLanguage,
        this.languageSubtags,
        this.script,
        this.region,
        this.variants,
        newValue,
        this.privateUse));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LangTag#extensions() extensions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of extensions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLangTag withExtensions(Iterable<String> elements) {
    if (this.extensions == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableLangTag(
        this.primaryLanguage,
        this.languageSubtags,
        this.script,
        this.region,
        this.variants,
        newValue,
        this.privateUse));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LangTag#privateUse() privateUse} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for privateUse
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLangTag withPrivateUse(String value) {
    String newValue = Objects.requireNonNull(value, "privateUse");
    if (this.privateUse.equals(newValue)) return this;
    return validate(new ImmutableLangTag(
        this.primaryLanguage,
        this.languageSubtags,
        this.script,
        this.region,
        this.variants,
        this.extensions,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLangTag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLangTag
        && equalTo((ImmutableLangTag) another);
  }

  private boolean equalTo(ImmutableLangTag another) {
    return primaryLanguage.equals(another.primaryLanguage)
        && languageSubtags.equals(another.languageSubtags)
        && script.equals(another.script)
        && region.equals(another.region)
        && variants.equals(another.variants)
        && extensions.equals(another.extensions)
        && privateUse.equals(another.privateUse);
  }

  /**
   * Computes a hash code from attributes: {@code primaryLanguage}, {@code languageSubtags}, {@code script}, {@code region}, {@code variants}, {@code extensions}, {@code privateUse}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + primaryLanguage.hashCode();
    h += (h << 5) + languageSubtags.hashCode();
    h += (h << 5) + script.hashCode();
    h += (h << 5) + region.hashCode();
    h += (h << 5) + variants.hashCode();
    h += (h << 5) + extensions.hashCode();
    h += (h << 5) + privateUse.hashCode();
    return h;
  }

  private static ImmutableLangTag validate(ImmutableLangTag instance) {
    instance.check();
    instance = (ImmutableLangTag) instance.normalize();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link LangTag} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LangTag instance
   */
  public static ImmutableLangTag copyOf(LangTag instance) {
    if (instance instanceof ImmutableLangTag) {
      return (ImmutableLangTag) instance;
    }
    return ImmutableLangTag.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLangTag ImmutableLangTag}.
   * <pre>
   * ImmutableLangTag.builder()
   *    .primaryLanguage(String) // optional {@link LangTag#primaryLanguage() primaryLanguage}
   *    .addLanguageSubtags|addAllLanguageSubtags(String) // {@link LangTag#languageSubtags() languageSubtags} elements
   *    .script(String) // optional {@link LangTag#script() script}
   *    .region(String) // optional {@link LangTag#region() region}
   *    .addVariants|addAllVariants(String) // {@link LangTag#variants() variants} elements
   *    .addExtensions|addAllExtensions(String) // {@link LangTag#extensions() extensions} elements
   *    .privateUse(String) // optional {@link LangTag#privateUse() privateUse}
   *    .build();
   * </pre>
   * @return A new ImmutableLangTag builder
   */
  public static ImmutableLangTag.Builder builder() {
    return new ImmutableLangTag.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLangTag ImmutableLangTag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LangTag", generator = "Immutables")
  public static final class Builder {
    private String primaryLanguage;
    private List<String> languageSubtags = new ArrayList<String>();
    private String script;
    private String region;
    private List<String> variants = new ArrayList<String>();
    private List<String> extensions = new ArrayList<String>();
    private String privateUse;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LangTag} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LangTag instance) {
      Objects.requireNonNull(instance, "instance");
      primaryLanguage(instance.primaryLanguage());
      addAllLanguageSubtags(instance.languageSubtags());
      script(instance.script());
      region(instance.region());
      addAllVariants(instance.variants());
      addAllExtensions(instance.extensions());
      privateUse(instance.privateUse());
      return this;
    }

    /**
     * Initializes the value for the {@link LangTag#primaryLanguage() primaryLanguage} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LangTag#primaryLanguage() primaryLanguage}.</em>
     * @param primaryLanguage The value for primaryLanguage 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder primaryLanguage(String primaryLanguage) {
      this.primaryLanguage = Objects.requireNonNull(primaryLanguage, "primaryLanguage");
      return this;
    }

    /**
     * Adds one element to {@link LangTag#languageSubtags() languageSubtags} list.
     * @param element A languageSubtags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLanguageSubtags(String element) {
      this.languageSubtags.add(Objects.requireNonNull(element, "languageSubtags element"));
      return this;
    }

    /**
     * Adds elements to {@link LangTag#languageSubtags() languageSubtags} list.
     * @param elements An array of languageSubtags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLanguageSubtags(String... elements) {
      for (String element : elements) {
        this.languageSubtags.add(Objects.requireNonNull(element, "languageSubtags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LangTag#languageSubtags() languageSubtags} list.
     * @param elements An iterable of languageSubtags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder languageSubtags(Iterable<String> elements) {
      this.languageSubtags.clear();
      return addAllLanguageSubtags(elements);
    }

    /**
     * Adds elements to {@link LangTag#languageSubtags() languageSubtags} list.
     * @param elements An iterable of languageSubtags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLanguageSubtags(Iterable<String> elements) {
      for (String element : elements) {
        this.languageSubtags.add(Objects.requireNonNull(element, "languageSubtags element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link LangTag#script() script} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LangTag#script() script}.</em>
     * @param script The value for script 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder script(String script) {
      this.script = Objects.requireNonNull(script, "script");
      return this;
    }

    /**
     * Initializes the value for the {@link LangTag#region() region} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LangTag#region() region}.</em>
     * @param region The value for region 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder region(String region) {
      this.region = Objects.requireNonNull(region, "region");
      return this;
    }

    /**
     * Adds one element to {@link LangTag#variants() variants} list.
     * @param element A variants element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVariants(String element) {
      this.variants.add(Objects.requireNonNull(element, "variants element"));
      return this;
    }

    /**
     * Adds elements to {@link LangTag#variants() variants} list.
     * @param elements An array of variants elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVariants(String... elements) {
      for (String element : elements) {
        this.variants.add(Objects.requireNonNull(element, "variants element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LangTag#variants() variants} list.
     * @param elements An iterable of variants elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder variants(Iterable<String> elements) {
      this.variants.clear();
      return addAllVariants(elements);
    }

    /**
     * Adds elements to {@link LangTag#variants() variants} list.
     * @param elements An iterable of variants elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVariants(Iterable<String> elements) {
      for (String element : elements) {
        this.variants.add(Objects.requireNonNull(element, "variants element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link LangTag#extensions() extensions} list.
     * @param element A extensions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addExtensions(String element) {
      this.extensions.add(Objects.requireNonNull(element, "extensions element"));
      return this;
    }

    /**
     * Adds elements to {@link LangTag#extensions() extensions} list.
     * @param elements An array of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addExtensions(String... elements) {
      for (String element : elements) {
        this.extensions.add(Objects.requireNonNull(element, "extensions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LangTag#extensions() extensions} list.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder extensions(Iterable<String> elements) {
      this.extensions.clear();
      return addAllExtensions(elements);
    }

    /**
     * Adds elements to {@link LangTag#extensions() extensions} list.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExtensions(Iterable<String> elements) {
      for (String element : elements) {
        this.extensions.add(Objects.requireNonNull(element, "extensions element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link LangTag#privateUse() privateUse} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LangTag#privateUse() privateUse}.</em>
     * @param privateUse The value for privateUse 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder privateUse(String privateUse) {
      this.privateUse = Objects.requireNonNull(privateUse, "privateUse");
      return this;
    }

    /**
     * Builds a new {@link ImmutableLangTag ImmutableLangTag}.
     * @return An immutable instance of LangTag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLangTag build() {
      return ImmutableLangTag.validate(new ImmutableLangTag(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
