/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak.client.auth;

import java.lang.reflect.Method;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.uberfire.ext.security.management.keycloak.client.auth.TokenManager;

public class BearerAuthenticationInterceptor
implements ClientExecutionInterceptor,
AcceptedByMethod {
    private TokenManager tokenManager;

    public BearerAuthenticationInterceptor(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public ClientResponse execute(ClientExecutionContext ctx) throws Exception {
        String token = this.tokenManager.getAccessTokenString();
        if (null != token) {
            ctx.getRequest().header("Authorization", (Object)("Bearer " + token));
        }
        return ctx.proceed();
    }

    public boolean accept(Class declaring, Method method) {
        String name = method.getName();
        boolean isToken = "grantToken".equals(name) || "refreshToken".equals(name);
        return !isToken;
    }
}

