/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.kie.workbench.common.forms.jbpm.server.service.impl.TaskFormVariables;

public class ProcessTaskFormsGenerationResult {
    private String processId;
    private Map<String, String> taskIdFormNameMap = new HashMap<String, String>();
    private Map<String, TaskFormVariables> taskFormVariablesRegistry = new HashMap<String, TaskFormVariables>();

    public ProcessTaskFormsGenerationResult(String processId) {
        this.processId = processId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public TaskFormVariables getTaskFormVariablesByTaskId(String taskId) {
        if (!this.taskIdFormNameMap.containsKey(taskId)) {
            return null;
        }
        return this.getTaskFormVariablesByFormName(this.taskIdFormNameMap.get(taskId));
    }

    public TaskFormVariables getTaskFormVariablesByFormName(String formName) {
        return this.taskFormVariablesRegistry.get(formName);
    }

    public Collection<TaskFormVariables> getAllTaskFormVariables() {
        return this.taskFormVariablesRegistry.values();
    }

    public void registerTaskFormVariables(String taskId, TaskFormVariables taskFormVariables) {
        this.taskIdFormNameMap.put(taskId, taskFormVariables.getTaskName());
        Optional<TaskFormVariables> optional = Optional.ofNullable(this.getTaskFormVariablesByFormName(taskFormVariables.getTaskName()));
        if (optional.isPresent()) {
            optional.get().merge(taskFormVariables);
        } else {
            taskFormVariables.setProcessId(this.processId);
            this.taskFormVariablesRegistry.put(taskFormVariables.getTaskName(), taskFormVariables);
        }
    }
}

