/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.util;

import java.lang.reflect.Type;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtil {
    private static final Logger logger = LoggerFactory.getLogger(ServiceUtil.class);

    public static String getManagedProperty(Properties properties, String propertyName) {
        return ServiceUtil.getManagedProperty(properties, propertyName, null);
    }

    public static String getManagedProperty(Properties properties, String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (ServiceUtil.isEmpty(propertyValue)) {
            propertyValue = properties.getProperty(propertyName);
        }
        return propertyValue != null ? propertyValue.trim() : defaultValue;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static Object getManagedBean(BeanManager beanManager, String beanName) {
        Set beans = beanManager.getBeans(beanName);
        if (beans == null || beans.isEmpty()) {
            logger.warn("Managed bean: " + beanName + " was not found.");
            return null;
        }
        logger.info("Getting reference to managed bean: " + beanName);
        Bean bean = (Bean)beans.iterator().next();
        if (beans.size() > 1) {
            logger.warn("Multiple beans were found for beanName: " + beanName + "Using the first one found in the classpath with fully classified classname '" + bean.getBeanClass());
        }
        CreationalContext context = beanManager.createCreationalContext((Contextual)bean);
        return beanManager.getReference(bean, (Type)bean.getBeanClass(), context);
    }
}

