/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;

public class URLConnectionFactory {
    private String driverClass;
    private URL driverURL;
    private String connectionURL;
    private Properties properties;
    private ClassLoader parent;
    private Driver driver;

    public URLConnectionFactory(URL driverURL, String driverClass, ClassLoader parent, String connectionURL, Properties properties) throws Exception {
        this.driverURL = driverURL;
        this.driverClass = driverClass;
        this.parent = parent;
        this.connectionURL = connectionURL;
        this.properties = properties;
        this.init();
    }

    public URLConnectionFactory(URL driverURL, String driverClass, String connectionURL, Properties properties) throws Exception {
        this(driverURL, driverClass, null, connectionURL, properties);
        this.init();
    }

    private void init() throws Exception {
        URL[] urls = new URL[]{this.driverURL};
        URLClassLoader classLoader = this.parent != null ? new URLClassLoader(urls, this.parent) : new URLClassLoader(urls);
        try {
            Class<?> clazz = classLoader.loadClass(this.driverClass);
            if (!Driver.class.isAssignableFrom(clazz)) {
                throw new Exception("Class: " + this.driverClass + " must extend: " + Driver.class.getName());
            }
            this.driver = (Driver)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Driver class: " + this.driverClass + " was not found.", e);
        }
    }

    public Connection createConnection() throws SQLException {
        return this.driver.connect(this.connectionURL, this.properties);
    }
}

