/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.EndEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.EndTerminateEvent;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class EndTerminateEventTest
extends EndEventTest<EndTerminateEvent> {
    private static final String BPMN_END_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endTerminateEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_1052A06B-1754-4CE4-ABF0-04A9772209DD";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_56ADEAE8-A2E3-4BC5-A6EB-04DD7F5307AD";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_36852679-C224-4244-899E-B6967F207B30";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_819BDB1B-9F61-4A8B-B2E5-D7625AC40CF1";
    private static final String EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_0E43EF74-ED54-4B8B-B58C-A6FE56DEC30F";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_67312F45-72EF-49BC-B60C-01C4EBC847CE";
    private static final String EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_8B8AA175-ACCB-4B39-BB87-EAE2E0F093D1";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_C910096C-ED66-47E1-A274-163759FF51BD";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 14;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "end event01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndTerminateEvent filledTopEvent = (EndTerminateEvent)this.getEndNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "end event01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndTerminateEvent emptyTopEvent = (EndTerminateEvent)this.getEndNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "end event03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndTerminateEvent filledSubprocessEvent = (EndTerminateEvent)this.getEndNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "end event03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndTerminateEvent emptySubprocessEvent = (EndTerminateEvent)this.getEndNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME = "end event02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndTerminateEvent filledSubprocessEvent = (EndTerminateEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "end event02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndTerminateEvent emptyEvent = (EndTerminateEvent)this.getEndNodeById(diagram, EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndTerminateEvent emptySubprocessEvent = (EndTerminateEvent)this.getEndNodeById(diagram, EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME = "end event04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndTerminateEvent filledSubprocessEvent = (EndTerminateEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "end event04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
    }

    @Override
    String getBpmnEndEventFilePath() {
        return BPMN_END_EVENT_FILE_PATH;
    }

    @Override
    Class<EndTerminateEvent> getEndEventType() {
        return EndTerminateEvent.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithIncomeId() {
        return FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithIncomeId() {
        return FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }
}

