/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem.service;

import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.WorkItemDefinitionParserTest;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.WorkItemDefinitionResources;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionVFSLookupService;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.DirectoryStream;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.backend.vfs.impl.DirectoryStreamImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkItemDefinitionVFSLookupServiceTest {
    private static final String WID_EMAIL = "org/kie/workbench/common/stunner/bpmn/backend/workitem/Email.wid";
    @Mock
    private VFSService vfsService;
    @Mock
    private WorkItemDefinitionResources resources;
    @Mock
    private Metadata metadata;
    @Mock
    private Path path;
    @Mock
    private Path widPath;
    private WorkItemDefinitionVFSLookupService tested;

    @Before
    public void init() throws Exception {
        String emailRaw = WorkItemDefinitionParserTest.loadStream(WID_EMAIL);
        Mockito.when((Object)this.vfsService.newDirectoryStream((Path)ArgumentMatchers.eq((Object)this.path), (DirectoryStream.Filter)ArgumentMatchers.any(DirectoryStream.Filter.class))).thenReturn((Object)new DirectoryStreamImpl(Collections.singletonList(this.widPath)));
        Mockito.when((Object)this.vfsService.readAllString((Path)ArgumentMatchers.eq((Object)this.widPath))).thenReturn((Object)emailRaw);
        Mockito.when((Object)this.resources.resolveResources((Metadata)ArgumentMatchers.eq((Object)this.metadata))).thenReturn(Collections.singleton(this.path));
        this.tested = new WorkItemDefinitionVFSLookupService(this.vfsService, this.resources);
    }

    @Test
    public void testFilter() {
        Collection result = this.tested.execute(this.metadata);
        ArgumentCaptor filterCaptor = ArgumentCaptor.forClass(DirectoryStream.Filter.class);
        ((VFSService)Mockito.verify((Object)this.vfsService, (VerificationMode)Mockito.times((int)1))).newDirectoryStream((Path)ArgumentMatchers.eq((Object)this.path), (DirectoryStream.Filter)filterCaptor.capture());
        DirectoryStream.Filter filter = (DirectoryStream.Filter)filterCaptor.getValue();
        Path path1 = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path1.getFileName()).thenReturn((Object)"someFile.wid");
        Assert.assertTrue((boolean)filter.accept((Object)path1));
        Mockito.when((Object)path1.getFileName()).thenReturn((Object)"someFile.bpmn");
        Assert.assertFalse((boolean)filter.accept((Object)path1));
        Mockito.when((Object)path1.getFileName()).thenReturn((Object)"someFile.WID");
        Assert.assertTrue((boolean)filter.accept((Object)path1));
        Mockito.when((Object)path1.getFileName()).thenReturn((Object)"someFile.WiD");
        Assert.assertTrue((boolean)filter.accept((Object)path1));
    }

    @Test
    public void testExecute() {
        Collection result = this.tested.execute(this.metadata);
        ArgumentCaptor filterCaptor = ArgumentCaptor.forClass(DirectoryStream.Filter.class);
        ((VFSService)Mockito.verify((Object)this.vfsService, (VerificationMode)Mockito.times((int)1))).newDirectoryStream((Path)ArgumentMatchers.eq((Object)this.path), (DirectoryStream.Filter)ArgumentMatchers.any(DirectoryStream.Filter.class));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        WorkItemDefinition wid = (WorkItemDefinition)result.iterator().next();
        Assert.assertEquals((Object)"Email", (Object)wid.getName());
    }
}

