/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.kie.dmn.model.api.DMNElementReference;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.v1_2.TAuthorityRequirement;
import org.kie.dmn.model.v1_2.TDMNElementReference;
import org.kie.dmn.model.v1_2.TDecision;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.dmn.model.v1_2.TInformationRequirement;
import org.kie.dmn.model.v1_2.TKnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.Question;
import org.kie.workbench.common.dmn.api.property.styling.StylingSet;
import org.kie.workbench.common.dmn.backend.definition.v1_1.AllowedAnswersPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DMNExternalLinksToExtensionElements;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ExpressionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.HrefBuilder;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InformationItemPrimaryPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.NodeConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.QuestionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public class DecisionConverter
implements NodeConverter<org.kie.dmn.model.api.Decision, Decision> {
    private FactoryManager factoryManager;

    public DecisionConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    @Override
    public Node<View<Decision>, ?> nodeFromDMN(org.kie.dmn.model.api.Decision dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        Node node = this.factoryManager.newElement(dmn.getId(), BindableAdapterUtils.getDefinitionId(Decision.class)).asNode();
        Id id = new Id(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Name name = new Name(dmn.getName());
        InformationItemPrimary informationItem = InformationItemPrimaryPropertyConverter.wbFromDMN(dmn.getVariable(), (org.kie.dmn.model.api.DMNModelInstrumentedBase)dmn);
        Expression expression = ExpressionPropertyConverter.wbFromDMN(dmn.getExpression(), hasComponentWidthsConsumer);
        Decision decision = new Decision(id, description, name, new Question(), new AllowedAnswers(), informationItem, expression, new StylingSet(), new GeneralRectangleDimensionsSet());
        decision.setQuestion(QuestionPropertyConverter.wbFromDMN(dmn.getQuestion()));
        decision.setAllowedAnswers(AllowedAnswersPropertyConverter.wbFromDMN(dmn.getAllowedAnswers()));
        ((View)node.getContent()).setDefinition((Object)decision);
        if (informationItem != null) {
            informationItem.setParent((DMNModelInstrumentedBase)decision);
        }
        if (expression != null) {
            expression.setParent((DMNModelInstrumentedBase)decision);
        }
        DMNExternalLinksToExtensionElements.loadExternalLinksFromExtensionElements((org.kie.dmn.model.api.DRGElement)dmn, (DRGElement)decision);
        return node;
    }

    @Override
    public org.kie.dmn.model.api.Decision dmnFromNode(Node<View<Decision>, ?> node, Consumer<ComponentWidths> componentWidthsConsumer) {
        Decision source = (Decision)DefinitionUtils.getElementDefinition(node);
        TDecision d = new TDecision();
        d.setId(source.getId().getValue());
        d.setDescription(DescriptionPropertyConverter.dmnFromWB(source.getDescription()));
        d.setName(source.getName().getValue());
        TInformationItem variable = InformationItemPrimaryPropertyConverter.dmnFromWB(source.getVariable(), (DMNModelInstrumentedBase)source);
        if (variable != null) {
            variable.setParent((org.kie.dmn.model.api.DMNModelInstrumentedBase)d);
        }
        d.setVariable((InformationItem)variable);
        org.kie.dmn.model.api.Expression expression = ExpressionPropertyConverter.dmnFromWB(source.getExpression(), componentWidthsConsumer);
        if (expression != null) {
            expression.setParent((org.kie.dmn.model.api.DMNModelInstrumentedBase)d);
        }
        d.setExpression(expression);
        d.setQuestion(QuestionPropertyConverter.dmnFromWB(source.getQuestion()));
        d.setAllowedAnswers(AllowedAnswersPropertyConverter.dmnFromWB(source.getAllowedAnswers()));
        List inEdges = node.getInEdges();
        for (Edge e : inEdges) {
            TDMNElementReference ri;
            TInformationRequirement iReq;
            View view;
            Node sourceNode = e.getSourceNode();
            if (!(sourceNode.getContent() instanceof View) || !((view = (View)sourceNode.getContent()).getDefinition() instanceof DRGElement)) continue;
            DRGElement drgElement = (DRGElement)view.getDefinition();
            if (drgElement instanceof Decision) {
                iReq = new TInformationRequirement();
                iReq.setId(e.getUUID());
                ri = new TDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredDecision((DMNElementReference)ri);
                d.getInformationRequirement().add(iReq);
                continue;
            }
            if (drgElement instanceof BusinessKnowledgeModel) {
                iReq = new TKnowledgeRequirement();
                iReq.setId(e.getUUID());
                ri = new TDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredKnowledge((DMNElementReference)ri);
                d.getKnowledgeRequirement().add(iReq);
                continue;
            }
            if (drgElement instanceof KnowledgeSource) {
                iReq = new TAuthorityRequirement();
                iReq.setId(e.getUUID());
                ri = new TDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredAuthority((DMNElementReference)ri);
                d.getAuthorityRequirement().add(iReq);
                continue;
            }
            if (drgElement instanceof InputData) {
                iReq = new TInformationRequirement();
                iReq.setId(e.getUUID());
                ri = new TDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredInput((DMNElementReference)ri);
                d.getInformationRequirement().add(iReq);
                continue;
            }
            if (drgElement instanceof DecisionService) {
                if (e.getContent() instanceof Child) continue;
                if (e.getContent() instanceof View && ((View)e.getContent()).getDefinition() instanceof KnowledgeRequirement) {
                    iReq = new TKnowledgeRequirement();
                    iReq.setId(e.getUUID());
                    ri = new TDMNElementReference();
                    ri.setHref(HrefBuilder.getHref(drgElement));
                    iReq.setRequiredKnowledge((DMNElementReference)ri);
                    d.getKnowledgeRequirement().add(iReq);
                    continue;
                }
                throw new UnsupportedOperationException("wrong model definition.");
            }
            throw new UnsupportedOperationException("wrong model definition.");
        }
        DMNExternalLinksToExtensionElements.loadExternalLinksIntoExtensionElements((DRGElement)source, (org.kie.dmn.model.api.DRGElement)d);
        return d;
    }
}

