/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.marshalling.DMNImportTypesHelper;
import org.kie.workbench.common.dmn.api.marshalling.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.editors.common.DMNDiagramHelper;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentFactory;
import org.kie.workbench.common.dmn.backend.editors.types.exceptions.DMNIncludeModelCouldNotBeCreatedException;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.uberfire.backend.vfs.Path;

@Dependent
public class IncludedModelFactory {
    private static final String DEFAULT_PACKAGE_NAME = "";
    private final DMNPathsHelper pathsHelper;
    private final DMNDiagramHelper diagramHelper;
    private final DMNImportTypesHelper importTypesHelper;
    private final PMMLIncludedDocumentFactory pmmlDocumentFactory;
    private final KieModuleService moduleService;

    @Inject
    public IncludedModelFactory(DMNDiagramHelper diagramHelper, DMNPathsHelper pathsHelper, DMNImportTypesHelper importTypesHelper, PMMLIncludedDocumentFactory pmmlDocumentFactory, KieModuleService moduleService) {
        this.diagramHelper = diagramHelper;
        this.pathsHelper = pathsHelper;
        this.importTypesHelper = importTypesHelper;
        this.pmmlDocumentFactory = pmmlDocumentFactory;
        this.moduleService = moduleService;
    }

    public IncludedModel create(Path dmnModelPath, Path includedModelPath) throws DMNIncludeModelCouldNotBeCreatedException {
        try {
            if (this.importTypesHelper.isDMN(includedModelPath)) {
                return this.makeDMNIncludedModel(dmnModelPath, includedModelPath);
            }
            if (this.importTypesHelper.isPMML(includedModelPath)) {
                return this.makePMMLIncludedModel(dmnModelPath, includedModelPath);
            }
            throw new IllegalArgumentException("Unsupported external model type.");
        }
        catch (Exception e) {
            throw new DMNIncludeModelCouldNotBeCreatedException();
        }
    }

    private IncludedModel makeDMNIncludedModel(Path dmnModelPath, Path includedModelPath) {
        String fileName = includedModelPath.getFileName();
        String modelPackage = this.getPackage(includedModelPath);
        String relativeURI = this.pathsHelper.getRelativeURI(dmnModelPath, includedModelPath);
        Diagram<Graph, Metadata> diagram = this.diagramHelper.getDiagramByPath(includedModelPath);
        String namespace = this.diagramHelper.getNamespace(diagram);
        String importType = DMNImportTypes.DMN.getDefaultNamespace();
        int drgElementCount = this.diagramHelper.getNodes(diagram).size();
        int itemDefinitionCount = this.diagramHelper.getItemDefinitions(diagram).size();
        return new DMNIncludedModel(fileName, modelPackage, relativeURI, namespace, importType, Integer.valueOf(drgElementCount), Integer.valueOf(itemDefinitionCount));
    }

    private IncludedModel makePMMLIncludedModel(Path dmnModelPath, Path includedModelPath) {
        String fileName = includedModelPath.getFileName();
        String modelPackage = this.getPackage(includedModelPath);
        String relativeURI = this.pathsHelper.getRelativeURI(dmnModelPath, includedModelPath);
        PMMLDocumentMetadata document = this.pmmlDocumentFactory.getDocumentByPath(includedModelPath);
        String importType = document.getImportType();
        int modelCount = document.getModels().size();
        return new PMMLIncludedModel(fileName, modelPackage, relativeURI, importType, Integer.valueOf(modelCount));
    }

    private String getPackage(Path path) {
        return Optional.ofNullable(this.moduleService.resolvePackage(path)).map(Package::getPackageName).orElse(DEFAULT_PACKAGE_NAME);
    }
}

