/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.dmn.core.pmml.PMMLInfo;
import org.kie.dmn.core.pmml.PMMLModelInfo;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLParameterMetadata;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;

@ApplicationScoped
public class PMMLIncludedDocumentFactory {
    private IOService ioService;

    public PMMLIncludedDocumentFactory() {
    }

    @Inject
    public PMMLIncludedDocumentFactory(@Named(value="ioStrategy") IOService ioService) {
        this.ioService = ioService;
    }

    public PMMLDocumentMetadata getDocumentByPath(Path path) {
        return Optional.ofNullable(this.loadPMMLInfo(path)).map(pmml -> this.convertPMMLInfo(path, (PMMLInfo<PMMLModelInfo>)pmml)).orElse(this.emptyPMMLDocumentMetadata(path));
    }

    public PMMLDocumentMetadata getDocumentByPath(Path path, PMMLIncludedModel includeModel) {
        String modelName = includeModel.getModelName();
        return Optional.ofNullable(this.loadPMMLInfo(path)).map(pmml -> this.convertPMMLInfo(path, (PMMLInfo<PMMLModelInfo>)pmml, modelName)).orElse(this.emptyPMMLDocumentMetadata(path, modelName));
    }

    PMMLInfo<PMMLModelInfo> loadPMMLInfo(Path path) {
        PMMLInfo pMMLInfo;
        block8: {
            InputStream io = this.ioService.newInputStream(Paths.convert((Path)path), new OpenOption[0]);
            try {
                pMMLInfo = PMMLInfo.from((InputStream)io);
                if (io == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (io != null) {
                        try {
                            io.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            io.close();
        }
        return pMMLInfo;
    }

    private PMMLDocumentMetadata emptyPMMLDocumentMetadata(Path path) {
        return new PMMLDocumentMetadata(path.toURI(), DMNImportTypes.PMML.getDefaultNamespace(), Collections.emptyList());
    }

    private PMMLDocumentMetadata emptyPMMLDocumentMetadata(Path path, String modelName) {
        return new PMMLDocumentMetadata(path.toURI(), modelName, DMNImportTypes.PMML.getDefaultNamespace(), Collections.emptyList());
    }

    private PMMLDocumentMetadata convertPMMLInfo(Path path, PMMLInfo<PMMLModelInfo> pmml) {
        return new PMMLDocumentMetadata(path.toURI(), pmml.getHeader().getPmmlNSURI(), this.convertPMMLInfoModels(pmml.getModels()));
    }

    private PMMLDocumentMetadata convertPMMLInfo(Path path, PMMLInfo<PMMLModelInfo> pmml, String modelName) {
        return new PMMLDocumentMetadata(path.toURI(), modelName, pmml.getHeader().getPmmlNSURI(), this.convertPMMLInfoModels(pmml.getModels()));
    }

    private List<PMMLModelMetadata> convertPMMLInfoModels(Collection<PMMLModelInfo> pmml) {
        return pmml.stream().map(this::convertPMMLModelInfo).collect(Collectors.toList());
    }

    private PMMLModelMetadata convertPMMLModelInfo(PMMLModelInfo pmml) {
        return new PMMLModelMetadata(pmml.getName(), this.convertInputFieldNames(pmml.getInputFieldNames()));
    }

    private Set<PMMLParameterMetadata> convertInputFieldNames(Collection<String> pmml) {
        return pmml.stream().map(this::convertInputFieldName).collect(Collectors.toSet());
    }

    private PMMLParameterMetadata convertInputFieldName(String name) {
        return new PMMLParameterMetadata(name);
    }
}

